/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PublicKey;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.crypto.SecretKey;

public class ImmutableDetector
implements Cloner {
    private static final Set<Class<?>> immutableClasses = ImmutableSet.of(StackTraceElement.class, BigDecimal.class, BigInteger.class, Locale.class, UUID.class, URL.class, (Object[])new Class[]{URI.class, Inet4Address.class, Inet6Address.class, InetSocketAddress.class, SecretKey.class, PublicKey.class});
    private static final Set<Class<?>> immutableNMS = ConcurrentHashMap.newKeySet();

    private static void add(Supplier<Class<?>> getClass) {
        try {
            Class<?> clazz = getClass.get();
            if (clazz != null) {
                immutableNMS.add(clazz);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void add(String className, String ... aliases) {
        Class<?> clazz = MinecraftReflection.getNullableNMS(className, aliases);
        if (clazz != null) {
            immutableNMS.add(clazz);
        }
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return ImmutableDetector.isImmutable(source.getClass());
    }

    public static boolean isImmutable(Class<?> type) {
        if (type.isArray()) {
            return false;
        }
        if (Primitives.isWrapperType(type) || String.class.equals(type)) {
            return true;
        }
        if (ImmutableDetector.isEnumWorkaround(type)) {
            return true;
        }
        if (type.getName().contains("$$Lambda$")) {
            return true;
        }
        if (immutableClasses.contains(type)) {
            return true;
        }
        for (Class<?> clazz : immutableNMS) {
            if (!MinecraftReflection.is(clazz, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEnumWorkaround(Class<?> enumClass) {
        while (enumClass != null) {
            if (enumClass.isEnum()) {
                return true;
            }
            enumClass = enumClass.getSuperclass();
        }
        return false;
    }

    @Override
    public Object clone(Object source) {
        return source;
    }

    static {
        ImmutableDetector.add(MinecraftReflection::getGameProfileClass);
        ImmutableDetector.add(MinecraftReflection::getDataWatcherSerializerClass);
        ImmutableDetector.add(MinecraftReflection::getBlockClass);
        ImmutableDetector.add(MinecraftReflection::getItemClass);
        ImmutableDetector.add("sounds.SoundEffect", "sounds.SoundEvents", "SoundEffect");
        if (MinecraftVersion.AQUATIC_UPDATE.atOrAbove()) {
            ImmutableDetector.add(MinecraftReflection::getFluidTypeClass);
            ImmutableDetector.add(MinecraftReflection::getParticleTypeClass);
            ImmutableDetector.add("core.particles.Particle", "core.particles.ParticleType", "Particle");
        }
        if (MinecraftVersion.VILLAGE_UPDATE.atOrAbove()) {
            ImmutableDetector.add(MinecraftReflection::getEntityTypes);
            ImmutableDetector.add("world.entity.npc.VillagerType", "VillagerType");
            ImmutableDetector.add("world.entity.npc.VillagerProfession", "VillagerProfession");
        }
        ImmutableDetector.add("world.entity.animal.CatVariant", new String[0]);
        ImmutableDetector.add("world.entity.animal.FrogVariant", new String[0]);
        if (MinecraftVersion.NETHER_UPDATE.atOrAbove()) {
            ImmutableDetector.add("core.IRegistry", "core.Registry", "IRegistry");
        }
        if (MinecraftVersion.NETHER_UPDATE_2.atOrAbove()) {
            ImmutableDetector.add(MinecraftReflection::getResourceKey);
        }
    }
}

