/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class WrappedRegistry {
    private static final Map<Class<?>, WrappedRegistry> REGISTRY;
    private static final MethodAccessor GET;
    private static final MethodAccessor GET_KEY;
    private final Object handle;

    private WrappedRegistry(Object handle) {
        this.handle = handle;
    }

    public Object get(MinecraftKey key) {
        return GET.invoke(this.handle, MinecraftKey.getConverter().getGeneric(key));
    }

    public Object get(String key) {
        return this.get(new MinecraftKey(key));
    }

    public MinecraftKey getKey(Object generic) {
        return MinecraftKey.getConverter().getSpecific(GET_KEY.invoke(this.handle, generic));
    }

    public static WrappedRegistry getAttributeRegistry() {
        return REGISTRY.get(MinecraftReflection.getAttributeBase());
    }

    public static WrappedRegistry getDimensionRegistry() {
        return REGISTRY.get(MinecraftReflection.getDimensionManager());
    }

    static {
        HashMap<Class, WrappedRegistry> regMap = new HashMap<Class, WrappedRegistry>();
        Class<?> regClass = MinecraftReflection.getIRegistry();
        if (regClass != null) {
            for (Field field : regClass.getFields()) {
                try {
                    ParameterizedType par;
                    Type paramType;
                    Type genType;
                    if (!field.getType().isAssignableFrom(regClass) || !((genType = field.getGenericType()) instanceof ParameterizedType) || !((paramType = (par = (ParameterizedType)genType).getActualTypeArguments()[0]) instanceof Class)) continue;
                    regMap.put((Class)paramType, new WrappedRegistry(field.get(null)));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        REGISTRY = ImmutableMap.copyOf(regMap);
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(regClass, false);
        GET = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnDerivedOf(Object.class).requireModifier(1024).parameterExactType(MinecraftReflection.getMinecraftKeyClass()).build()));
        GET_KEY = Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).returnTypeExact(MinecraftReflection.getMinecraftKeyClass()).build()));
    }
}

