/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.timing.StatisticsStream;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TimedTracker {
    private final AtomicInteger observations = new AtomicInteger();
    private final Map<PacketType, StatisticsStream> packets = new HashMap<PacketType, StatisticsStream>();

    public long beginTracking() {
        return System.nanoTime();
    }

    public synchronized void endTracking(long trackingToken, PacketType type) {
        StatisticsStream stream = this.packets.get(type);
        if (stream == null) {
            stream = new StatisticsStream();
            this.packets.put(type, stream);
        }
        stream.observe(System.nanoTime() - trackingToken);
        this.observations.incrementAndGet();
    }

    public int getObservations() {
        return this.observations.get();
    }

    public synchronized Map<PacketType, StatisticsStream> getStatistics() {
        HashMap clone = Maps.newHashMap();
        for (Map.Entry<PacketType, StatisticsStream> entry : this.packets.entrySet()) {
            clone.put(entry.getKey(), new StatisticsStream(entry.getValue()));
        }
        return clone;
    }
}

