/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.compiler;

import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.compiler.StructureCompiler;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public abstract class CompiledStructureModifier
extends StructureModifier<Object> {
    protected StructureCompiler compiler;
    private Set<Integer> exempted;

    public CompiledStructureModifier() {
        this.customConvertHandling = true;
    }

    @Override
    public void setReadOnly(int fieldIndex, boolean value) throws FieldAccessException {
        if (this.isReadOnly(fieldIndex) && !value) {
            if (this.exempted == null) {
                this.exempted = Sets.newHashSet();
            }
            this.exempted.add(fieldIndex);
        }
        if (!(this.isReadOnly(fieldIndex) || !value || this.exempted != null && this.exempted.contains(fieldIndex))) {
            throw new IllegalStateException("Cannot make compiled field " + fieldIndex + " read only.");
        }
    }

    @Override
    public StructureModifier<Object> writeDefaults() throws FieldAccessException {
        DefaultInstances generator = DefaultInstances.DEFAULT;
        for (Map.Entry entry : this.defaultFields.entrySet()) {
            Integer index = (Integer)entry.getValue();
            Field field = (Field)entry.getKey();
            if (field.getType().getCanonicalName().equals("net.md_5.bungee.api.chat.BaseComponent[]")) {
                this.write((int)index, (Object)null);
                continue;
            }
            this.write((int)index, generator.getDefault(field.getType()));
        }
        return this;
    }

    @Override
    public final Object read(int fieldIndex) throws FieldAccessException {
        Object result = this.readGenerated(fieldIndex);
        if (this.converter != null) {
            return this.converter.getSpecific(result);
        }
        return result;
    }

    protected Object readReflected(int index) throws FieldAccessException {
        return super.read(index);
    }

    protected abstract Object readGenerated(int var1) throws FieldAccessException;

    @Override
    public StructureModifier<Object> write(int index, Object value) throws FieldAccessException {
        if (this.converter != null) {
            value = this.converter.getGeneric(value);
        }
        return this.writeGenerated(index, value);
    }

    protected void writeReflected(int index, Object value) throws FieldAccessException {
        super.write(index, value);
    }

    protected abstract StructureModifier<Object> writeGenerated(int var1, Object var2) throws FieldAccessException;

    @Override
    public StructureModifier<Object> withTarget(Object target) {
        if (this.compiler != null) {
            return this.compiler.compile(super.withTarget(target));
        }
        return super.withTarget(target);
    }
}

