/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.UnsafeFieldAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;

final class DefaultFieldAccessor
implements FieldAccessor {
    private final Field field;
    private MethodHandle setter;

    public DefaultFieldAccessor(Field field) {
        this.field = field;
        if (UnsafeFieldAccess.hasTrustedLookup()) {
            try {
                this.setter = UnsafeFieldAccess.findSetter(field);
            }
            catch (ReflectiveOperationException exception) {
                ProtocolLogger.debug("Unable to get setter for field " + field, exception);
            }
        }
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot read  " + this.field, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            if (this.setter == null) {
                this.field.set(instance, value);
            } else {
                this.setter.invoke(instance, value);
            }
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new RuntimeException("Cannot set field " + this.field + " to value " + value, e);
        }
        catch (IllegalAccessException | WrongMethodTypeException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
        catch (Throwable ignored) {
            throw new RuntimeException("Cannot happen");
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public int hashCode() {
        return this.field != null ? this.field.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFieldAccessor) {
            DefaultFieldAccessor other = (DefaultFieldAccessor)obj;
            return other.field == this.field;
        }
        return true;
    }

    public String toString() {
        return "DefaultFieldAccessor [field=" + this.field + "]";
    }
}

