/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

abstract class NettyEventLoopProxy
implements EventLoop {
    private static final Callable<?> EMPTY_CALLABLE = () -> null;
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private final EventLoop delegate;

    public NettyEventLoopProxy(EventLoop delegate) {
        this.delegate = delegate;
    }

    protected abstract Runnable proxyRunnable(Runnable var1);

    protected abstract <T> Callable<T> proxyCallable(Callable<T> var1);

    public EventLoopGroup parent() {
        return this.delegate.parent();
    }

    public EventLoop next() {
        return this.delegate.next();
    }

    public boolean inEventLoop() {
        return this.delegate.inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return this.delegate.inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return this.delegate.newPromise();
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return this.delegate.newSucceededFuture(result);
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    public Future<?> submit(Runnable task) {
        Runnable proxied = this.proxyRunnable(task);
        return this.delegate.submit(proxied == null ? EMPTY_RUNNABLE : proxied);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        Runnable proxied = this.proxyRunnable(task);
        return this.delegate.submit(proxied == null ? EMPTY_RUNNABLE : proxied, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        Callable<T> proxied = this.proxyCallable(task);
        return this.delegate.submit(proxied == null ? EMPTY_CALLABLE : proxied);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Runnable proxied = this.proxyRunnable(command);
        return this.delegate.schedule(proxied == null ? EMPTY_RUNNABLE : proxied, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Callable<V> proxied = this.proxyCallable(callable);
        return this.delegate.schedule(callable == null ? EMPTY_CALLABLE : proxied, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Runnable proxied = this.proxyRunnable(command);
        return this.delegate.scheduleAtFixedRate(proxied == null ? EMPTY_RUNNABLE : proxied, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Runnable proxied = this.proxyRunnable(command);
        return this.delegate.scheduleWithFixedDelay(proxied == null ? EMPTY_RUNNABLE : proxied, initialDelay, delay, unit);
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        Runnable proxied = this.proxyRunnable(command);
        if (proxied != null) {
            this.delegate.execute(proxied);
        }
    }

    public void forEach(Consumer<? super EventExecutor> action) {
        this.delegate.forEach(action);
    }

    public Spliterator<EventExecutor> spliterator() {
        return this.delegate.spliterator();
    }

    public ChannelFuture register(Channel channel) {
        return this.delegate.register(channel);
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.delegate.register(channel, promise);
    }
}

