/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.NetworkProcessor;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.channel.InboundPacketInterceptor;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import com.comphenix.protocol.injector.netty.channel.NettyChannelProxy;
import com.comphenix.protocol.injector.netty.channel.NettyEventLoopProxy;
import com.comphenix.protocol.injector.netty.channel.WirePacketEncoder;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.ByteBuddyGenerated;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftProtocolVersion;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class NettyChannelInjector
implements Injector {
    private static final FieldAccessor NO_OP_ACCESSOR = new FieldAccessor(){

        @Override
        public Object get(Object instance) {
            return null;
        }

        @Override
        public void set(Object instance, Object value) {
        }

        @Override
        public Field getField() {
            return null;
        }
    };
    private static final String INTERCEPTOR_NAME = "protocol_lib_inbound_interceptor";
    private static final String WIRE_PACKET_ENCODER_NAME = "protocol_lib_wire_packet_encoder";
    private static final String[] PROTOCOL_LIB_HANDLERS = new String[]{"protocol_lib_wire_packet_encoder", "protocol_lib_inbound_interceptor"};
    private static final ReportType REPORT_CANNOT_SEND_PACKET = new ReportType("Unable to send packet %s to %s");
    private static final WirePacketEncoder WIRE_PACKET_ENCODER = new WirePacketEncoder();
    private static final Map<Class<?>, FieldAccessor> PACKET_ACCESSORS = new ConcurrentHashMap(16, 0.9f);
    private static final Class<?> LOGIN_PACKET_START_CLASS = PacketType.Login.Client.START.getPacketClass();
    private static final Class<?> PACKET_PROTOCOL_CLASS = PacketType.Handshake.Client.SET_PROTOCOL.getPacketClass();
    private static final AttributeKey<Integer> PROTOCOL_VERSION = AttributeKey.valueOf((String)NettyChannelInjector.getRandomKey());
    private static final AttributeKey<NettyChannelInjector> INJECTOR = AttributeKey.valueOf((String)NettyChannelInjector.getRandomKey());
    private static FieldAccessor LOGIN_GAME_PROFILE;
    private static FieldAccessor PROTOCOL_VERSION_ACCESSOR;
    private final Server server;
    private final ErrorReporter errorReporter;
    private final NetworkProcessor networkProcessor;
    private final Object networkManager;
    private final Channel wrappedChannel;
    private final ChannelListener channelListener;
    private final InjectionFactory injectionFactory;
    private final FieldAccessor channelField;
    private final Set<Object> skippedPackets = new LinkedHashSet<Object>();
    private final Map<Object, NetworkMarker> savedMarkers = new WeakHashMap<Object, NetworkMarker>(16, 0.9f);
    private volatile boolean closed = false;
    private volatile boolean injected = false;
    private String playerName;
    private Player resolvedPlayer;
    private Object playerConnection;
    private FieldAccessor protocolAccessor;

    public NettyChannelInjector(Server server, Object netManager, Channel channel, ChannelListener listener, InjectionFactory injector, ErrorReporter errorReporter) {
        this.server = server;
        this.errorReporter = errorReporter;
        this.networkProcessor = new NetworkProcessor(errorReporter);
        this.networkManager = netManager;
        this.wrappedChannel = channel;
        this.channelListener = listener;
        this.injectionFactory = injector;
        this.wrappedChannel.attr(INJECTOR).set((Object)this);
        Field channelField = FuzzyReflection.fromObject(netManager, true).getField(FuzzyFieldContract.newBuilder().typeExact(Channel.class).banModifier(8).build());
        this.channelField = Accessors.getFieldAccessor(channelField, true);
        this.wrappedChannel.closeFuture().addListener(future -> this.close());
    }

    static NettyChannelInjector findInjector(Channel channel) {
        return (NettyChannelInjector)channel.attr(INJECTOR).get();
    }

    static Object findChannelHandler(Channel channel, Class<?> type) {
        for (Map.Entry entry : channel.pipeline()) {
            if (!type.isAssignableFrom(((ChannelHandler)entry.getValue()).getClass())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static String getRandomKey() {
        return Long.toString(System.nanoTime());
    }

    private static boolean hasProtocolLibHandler(Channel channel) {
        for (String handler : PROTOCOL_LIB_HANDLERS) {
            if (channel.pipeline().get(handler) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getProtocolVersion() {
        Integer protocolVersion = (Integer)this.wrappedChannel.attr(PROTOCOL_VERSION).get();
        return protocolVersion == null ? MinecraftProtocolVersion.getCurrentVersion() : protocolVersion;
    }

    @Override
    public boolean inject() {
        if (this.wrappedChannel.eventLoop().inEventLoop()) {
            if (this.closed || this.wrappedChannel instanceof ByteBuddyFactory || !this.wrappedChannel.isActive()) {
                return false;
            }
            this.rewriteChannelField();
            if (NettyChannelInjector.hasProtocolLibHandler(this.wrappedChannel)) {
                return false;
            }
            this.wrappedChannel.pipeline().addAfter("encoder", WIRE_PACKET_ENCODER_NAME, (ChannelHandler)WIRE_PACKET_ENCODER);
            this.wrappedChannel.pipeline().addAfter("decoder", INTERCEPTOR_NAME, (ChannelHandler)new InboundPacketInterceptor(this, this.channelListener, this.networkProcessor));
            this.injected = true;
            return true;
        }
        this.ensureInEventLoop(this::inject);
        return false;
    }

    @Override
    public void uninject() {
        if (this.injected) {
            if (this.wrappedChannel.eventLoop().inEventLoop()) {
                this.injected = false;
                this.wrappedChannel.attr(INJECTOR).remove();
                this.channelField.set(this.networkManager, this.wrappedChannel);
                for (String handler : PROTOCOL_LIB_HANDLERS) {
                    try {
                        this.wrappedChannel.pipeline().remove(handler);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            } else {
                this.ensureInEventLoop(this::uninject);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.uninject();
            this.savedMarkers.clear();
            this.skippedPackets.clear();
            this.injectionFactory.invalidate(this.getPlayer(), this.playerName);
        }
    }

    @Override
    public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) {
        if (this.closed || !this.injected) {
            return;
        }
        if (!filtered) {
            this.skippedPackets.add(packet);
        }
        this.saveMarker(packet, marker);
        try {
            if (this.resolvedPlayer instanceof ByteBuddyGenerated) {
                MinecraftMethods.getNetworkManagerHandleMethod().invoke(this.networkManager, packet);
            } else {
                Object playerConnection = this.getPlayerConnection();
                if (playerConnection != null) {
                    MinecraftMethods.getSendPacketMethod().invoke(playerConnection, packet);
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_SEND_PACKET).messageParam(packet, this.playerName).error(exception).build());
        }
    }

    @Override
    public void receiveClientPacket(Object packet) {
        if (this.closed || !this.injected) {
            return;
        }
        Runnable receiveAction = () -> {
            try {
                MinecraftMethods.getNetworkManagerReadPacketMethod().invoke(this.networkManager, null, packet);
            }
            catch (Exception exception) {
                this.errorReporter.reportMinimal(this.injectionFactory.getPlugin(), "receiveClientPacket", exception);
            }
        };
        if (this.wrappedChannel.eventLoop().inEventLoop()) {
            receiveAction.run();
        } else {
            this.ensureInEventLoop(receiveAction);
        }
    }

    @Override
    public PacketType.Protocol getCurrentProtocol() {
        if (this.protocolAccessor == null) {
            this.protocolAccessor = Accessors.getFieldAccessor(this.networkManager.getClass(), MinecraftReflection.getEnumProtocolClass(), true);
        }
        Object nmsProtocol = this.protocolAccessor.get(this.networkManager);
        return PacketType.Protocol.fromVanilla((Enum)nmsProtocol);
    }

    @Override
    public NetworkMarker getMarker(Object packet) {
        return this.savedMarkers.get(packet);
    }

    @Override
    public void saveMarker(Object packet, NetworkMarker marker) {
        if (marker != null && !this.closed) {
            this.savedMarkers.put(packet, marker);
        }
    }

    @Override
    public Player getPlayer() {
        if (this.resolvedPlayer != null) {
            return this.resolvedPlayer;
        }
        if (this.playerName != null) {
            this.resolvedPlayer = this.server.getPlayerExact(this.playerName);
        }
        return this.resolvedPlayer;
    }

    @Override
    public void setPlayer(Player player) {
        this.resolvedPlayer = player;
        this.playerName = player.getName();
    }

    @Override
    public void disconnect(String message) {
        if (this.playerConnection == null || this.resolvedPlayer instanceof ByteBuddyGenerated) {
            this.wrappedChannel.disconnect();
        } else {
            try {
                MinecraftMethods.getDisconnectMethod(this.playerConnection.getClass()).invoke(this.playerConnection, message);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unable to disconnect the current injector", exception);
            }
        }
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    void tryProcessLogin(Object packet) {
        if (LOGIN_PACKET_START_CLASS != null && LOGIN_PACKET_START_CLASS.equals(packet.getClass())) {
            if (LOGIN_GAME_PROFILE == null) {
                LOGIN_GAME_PROFILE = Accessors.getFieldAccessor(LOGIN_PACKET_START_CLASS, MinecraftReflection.getGameProfileClass(), true);
            }
            WrappedGameProfile profile = WrappedGameProfile.fromHandle(LOGIN_GAME_PROFILE.get(packet));
            this.playerName = profile.getName();
            this.injectionFactory.cacheInjector(profile.getName(), (Injector)this);
            return;
        }
        if (PACKET_PROTOCOL_CLASS != null && PACKET_PROTOCOL_CLASS.equals(packet.getClass())) {
            if (PROTOCOL_VERSION_ACCESSOR == null) {
                try {
                    Field ver = FuzzyReflection.fromClass(PACKET_PROTOCOL_CLASS, true).getField(FuzzyFieldContract.newBuilder().banModifier(8).typeExact(Integer.TYPE).build());
                    PROTOCOL_VERSION_ACCESSOR = Accessors.getFieldAccessor(ver, true);
                }
                catch (IllegalArgumentException exception) {
                    PROTOCOL_VERSION_ACCESSOR = NO_OP_ACCESSOR;
                }
            }
            if (PROTOCOL_VERSION_ACCESSOR != NO_OP_ACCESSOR) {
                int protocolVersion = (Integer)PROTOCOL_VERSION_ACCESSOR.get(packet);
                this.wrappedChannel.attr(PROTOCOL_VERSION).set((Object)protocolVersion);
            }
        }
    }

    private void rewriteChannelField() {
        Object currentChannel = this.channelField.get(this.networkManager);
        if (currentChannel instanceof NettyChannelProxy) {
            return;
        }
        NettyChannelProxy ch = new NettyChannelProxy(this.wrappedChannel, new NettyEventLoopProxy(this.wrappedChannel.eventLoop()){

            @Override
            protected Runnable proxyRunnable(Runnable original) {
                return (Runnable)NettyChannelInjector.this.processOutbound(original);
            }

            @Override
            protected <T> Callable<T> proxyCallable(Callable<T> original) {
                return (Callable)NettyChannelInjector.this.processOutbound(original);
            }
        });
        this.channelField.set(this.networkManager, ch);
    }

    private void ensureInEventLoop(Runnable runnable) {
        this.wrappedChannel.eventLoop().execute(runnable);
    }

    private <T> T processOutbound(T action) {
        FieldAccessor packetAccessor = this.lookupPacketAccessor(action);
        if (packetAccessor == NO_OP_ACCESSOR) {
            return action;
        }
        Object packet = packetAccessor.get(action);
        if (packet == null) {
            return action;
        }
        NetworkMarker marker = this.savedMarkers.remove(packet);
        if (this.skippedPackets.remove(packet)) {
            if (marker != null) {
                return this.proxyAction(action, null, marker);
            }
            return action;
        }
        if (!this.channelListener.hasListener(packet.getClass()) && marker == null) {
            return action;
        }
        if (this.channelListener.hasMainThreadListener(packet.getClass()) && !this.server.isPrimaryThread()) {
            this.server.getScheduler().scheduleSyncDelayedTask(this.injectionFactory.getPlugin(), () -> this.sendServerPacket(packet, null, false));
            return null;
        }
        if (!this.channelListener.hasMainThreadListener(packet.getClass()) && this.server.isPrimaryThread()) {
            this.server.getScheduler().runTaskAsynchronously(this.injectionFactory.getPlugin(), () -> this.sendServerPacket(packet, null, false));
            return null;
        }
        PacketEvent event = this.channelListener.onPacketSending(this, packet, marker);
        if (event == null) {
            return action;
        }
        if (!event.isCancelled()) {
            NetworkMarker eventMarker;
            Object interceptedPacket = event.getPacket().getHandle();
            if (interceptedPacket != packet) {
                packetAccessor.set(action, interceptedPacket);
            }
            if ((eventMarker = NetworkMarker.getNetworkMarker(event)) == null) {
                return action;
            }
            return this.proxyAction(action, event, eventMarker);
        }
        return null;
    }

    private <T> T proxyAction(T action, PacketEvent event, NetworkMarker marker) {
        if (action instanceof Runnable) {
            return (T)((Runnable)() -> {
                ((Runnable)action).run();
                this.networkProcessor.invokePostEvent(event, marker);
            });
        }
        if (action instanceof Callable) {
            return (T)((Callable<Object>)() -> {
                Object value = ((Callable)action).call();
                this.networkProcessor.invokePostEvent(event, marker);
                return value;
            });
        }
        throw new IllegalStateException("Unexpected input action of type " + action.getClass());
    }

    private FieldAccessor lookupPacketAccessor(Object action) {
        return PACKET_ACCESSORS.computeIfAbsent(action.getClass(), clazz -> {
            try {
                return Accessors.getFieldAccessor(action.getClass(), MinecraftReflection.getPacketClass(), true);
            }
            catch (IllegalArgumentException exception) {
                return NO_OP_ACCESSOR;
            }
        });
    }

    private Object getPlayerConnection() {
        if (this.playerConnection == null) {
            Player target = this.getPlayer();
            if (target == null) {
                return null;
            }
            this.playerConnection = MinecraftFields.getPlayerConnection(target);
        }
        return this.playerConnection;
    }

    public Channel getWrappedChannel() {
        return this.wrappedChannel;
    }
}

