/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.channel.EmptyInjector;
import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.injector.netty.channel.NettyChannelMinimalInjector;
import com.comphenix.protocol.injector.temporary.MinimalInjector;
import com.comphenix.protocol.injector.temporary.TemporaryPlayerFactory;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.MinecraftFields;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.collect.MapMaker;
import io.netty.channel.Channel;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InjectionFactory {
    private final ConcurrentMap<String, Injector> nameLookup = new MapMaker().weakValues().makeMap();
    private final ConcurrentMap<Player, Injector> playerLookup = new MapMaker().weakKeys().weakValues().makeMap();
    private final Plugin plugin;
    private final Server server;
    private final ErrorReporter errorReporter;
    private boolean closed;

    public InjectionFactory(Plugin plugin, Server server, ErrorReporter errorReporter) {
        this.plugin = plugin;
        this.server = server;
        this.errorReporter = errorReporter;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Nonnull
    public Injector fromPlayer(Player player, ChannelListener listener) {
        if (this.closed) {
            return new EmptyInjector(player);
        }
        Injector injector = (Injector)this.playerLookup.get(player);
        if (injector == null) {
            injector = this.getTemporaryInjector(player);
        }
        if (injector != null && !injector.isClosed()) {
            return injector;
        }
        Object networkManager = MinecraftFields.getNetworkManager(player);
        if (networkManager == null) {
            return this.fromName(player.getName(), player);
        }
        Channel channel = FuzzyReflection.getFieldValue(networkManager, Channel.class, true);
        injector = NettyChannelInjector.findInjector(channel);
        if (injector != null) {
            if (injector.getPlayer() != player || !this.playerLookup.containsKey(player)) {
                this.playerLookup.remove(injector.getPlayer());
                this.cacheInjector(player, injector);
                injector.setPlayer(player);
            }
        } else {
            injector = new NettyChannelInjector(this.server, networkManager, channel, listener, this, this.errorReporter);
            this.cacheInjector(player, injector);
        }
        return injector;
    }

    public Injector fromName(String name, Player player) {
        if (this.closed) {
            return new EmptyInjector(player);
        }
        Injector injector = (Injector)this.nameLookup.get(name);
        if (injector != null) {
            injector.setPlayer(player);
            return injector;
        }
        return new EmptyInjector(player);
    }

    @Nonnull
    public Injector fromChannel(Channel channel, ChannelListener listener, TemporaryPlayerFactory playerFactory) {
        if (this.closed) {
            return EmptyInjector.WITHOUT_PLAYER;
        }
        Object netManager = this.findNetworkManager(channel);
        Player temporaryPlayer = playerFactory.createTemporaryPlayer(this.server);
        NettyChannelInjector injector = new NettyChannelInjector(this.server, netManager, channel, listener, this, this.errorReporter);
        NettyChannelMinimalInjector minimalInjector = new NettyChannelMinimalInjector(injector);
        TemporaryPlayerFactory.setInjectorInPlayer(temporaryPlayer, minimalInjector);
        return injector;
    }

    public Injector invalidate(Player player, String name) {
        Injector injector = null;
        if (name != null) {
            injector = (Injector)this.nameLookup.remove(name);
        }
        if (player != null) {
            injector = (Injector)this.playerLookup.remove(player);
        }
        return injector;
    }

    public Injector cacheInjector(Player player, Injector injector) {
        this.nameLookup.put(player.getName(), injector);
        return this.playerLookup.put(player, injector);
    }

    public Injector cacheInjector(String name, Injector injector) {
        return this.nameLookup.put(name, injector);
    }

    private NettyChannelInjector getTemporaryInjector(Player player) {
        MinimalInjector injector = TemporaryPlayerFactory.getInjectorFromPlayer(player);
        if (injector instanceof NettyChannelMinimalInjector) {
            return ((NettyChannelMinimalInjector)injector).getInjector();
        }
        return null;
    }

    private Object findNetworkManager(Channel channel) {
        Object networkManager = NettyChannelInjector.findChannelHandler(channel, MinecraftReflection.getNetworkManagerClass());
        if (networkManager != null) {
            return networkManager;
        }
        throw new IllegalArgumentException("Unable to find NetworkManager in " + channel);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (Injector injector : this.playerLookup.values()) {
                injector.close();
            }
            for (Injector injector : this.nameLookup.values()) {
                injector.close();
            }
        }
    }
}

