/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.NetworkProcessor;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.utility.MinecraftReflection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

final class InboundPacketInterceptor
extends ChannelInboundHandlerAdapter {
    private final NettyChannelInjector injector;
    private final ChannelListener channelListener;
    private final NetworkProcessor networkProcessor;

    public InboundPacketInterceptor(NettyChannelInjector injector, ChannelListener listener, NetworkProcessor processor) {
        this.injector = injector;
        this.channelListener = listener;
        this.networkProcessor = processor;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.shouldInterceptMessage(msg)) {
            this.injector.tryProcessLogin(msg);
            PacketEvent interceptionResult = this.channelListener.onPacketReceiving(this.injector, msg, null);
            if (interceptionResult == null) {
                ctx.fireChannelRead(msg);
                return;
            }
            if (!interceptionResult.isCancelled()) {
                ctx.fireChannelRead(interceptionResult.getPacket().getHandle());
                NetworkMarker marker = NetworkMarker.getNetworkMarker(interceptionResult);
                if (marker != null) {
                    this.networkProcessor.invokePostEvent(interceptionResult, marker);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean shouldInterceptMessage(Object msg) {
        return MinecraftReflection.getPacketClass().isAssignableFrom(msg.getClass());
    }
}

