/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.implementation.FixedValue;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.compiler.BackgroundCompiler;
import com.comphenix.protocol.reflect.compiler.CompiledStructureModifier;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.ZeroBuffer;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class StructureCache {
    private static final Set<PacketType> COMPILING = new HashSet<PacketType>();
    private static final Map<Class<?>, Supplier<Object>> PACKET_INSTANCE_CREATORS = new ConcurrentHashMap();
    private static final Map<PacketType, StructureModifier<Object>> STRUCTURE_MODIFIER_CACHE = new ConcurrentHashMap<PacketType, StructureModifier<Object>>();
    private static boolean TRICK_TRIED = false;
    private static ConstructorAccessor TRICKED_DATA_SERIALIZER;

    public static Object newPacket(Class<?> clazz) {
        Object result = DefaultInstances.DEFAULT.create(clazz);
        if (result == null) {
            return PACKET_INSTANCE_CREATORS.computeIfAbsent(clazz, $ -> {
                ConstructorAccessor accessor = Accessors.getConstructorAccessorOrNull(clazz, MinecraftReflection.getPacketDataSerializerClass());
                if (accessor != null) {
                    return () -> {
                        try {
                            return accessor.invoke(MinecraftReflection.getPacketDataSerializer((Object)new ZeroBuffer()));
                        }
                        catch (Exception exception) {
                            ConstructorAccessor trickyDataSerializerAccessor = StructureCache.getTrickDataSerializerOrNull();
                            if (trickyDataSerializerAccessor != null) {
                                return accessor.invoke(trickyDataSerializerAccessor.invoke(new Object[]{new ZeroBuffer()}));
                            }
                            throw new IllegalArgumentException("Unable to create packet " + clazz, exception);
                        }
                    };
                }
                throw new IllegalArgumentException("No matching constructor to create packet in class " + clazz);
            }).get();
        }
        return result;
    }

    public static Object newPacket(PacketType type) {
        return StructureCache.newPacket(PacketRegistry.getPacketClassFromType(type));
    }

    public static StructureModifier<Object> getStructure(PacketType type) {
        return StructureCache.getStructure(type, true);
    }

    public static StructureModifier<Object> getStructure(Class<?> packetType) {
        return StructureCache.getStructure(packetType, true);
    }

    public static StructureModifier<Object> getStructure(Class<?> packetType, boolean compile) {
        PacketType type = PacketRegistry.getPacketType(packetType);
        Preconditions.checkNotNull((Object)type, (Object)("No packet type associated with " + packetType));
        return StructureCache.getStructure(type, compile);
    }

    public static StructureModifier<Object> getStructure(PacketType packetType, boolean compile) {
        BackgroundCompiler compiler;
        Preconditions.checkNotNull((Object)packetType, (Object)"type cannot be null");
        StructureModifier modifier = STRUCTURE_MODIFIER_CACHE.computeIfAbsent(packetType, type -> {
            Class<?> packetClass = PacketRegistry.getPacketClassFromType(type);
            return new StructureModifier(packetClass, MinecraftReflection.getPacketClass(), true);
        });
        if (compile && !(modifier instanceof CompiledStructureModifier) && COMPILING.add(packetType) && (compiler = BackgroundCompiler.getInstance()) != null) {
            compiler.scheduleCompilation(modifier, compiled -> STRUCTURE_MODIFIER_CACHE.put(packetType, compiled));
        }
        return modifier;
    }

    private static ConstructorAccessor getTrickDataSerializerOrNull() {
        if (TRICKED_DATA_SERIALIZER == null && !TRICK_TRIED) {
            TRICK_TRIED = true;
            try {
                Object compound = Accessors.getConstructorAccessor(MinecraftReflection.getNBTCompoundClass(), new Class[0]).invoke(new Object[0]);
                Class generatedClass = ByteBuddyFactory.getInstance().createSubclass(MinecraftReflection.getPacketDataSerializerClass()).name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializer").method(ElementMatchers.returns(MinecraftReflection.getNBTCompoundClass()).and(ElementMatchers.takesArguments(MinecraftReflection.getNBTReadLimiterClass()))).intercept(FixedValue.value(compound)).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
                TRICKED_DATA_SERIALIZER = Accessors.getConstructorAccessor(generatedClass, ByteBuf.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return TRICKED_DATA_SERIALIZER;
    }
}

