/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketPostListener;
import com.comphenix.protocol.events.ScheduledPacket;
import java.util.Set;

public class NetworkProcessor {
    private final ErrorReporter reporter;

    public NetworkProcessor(ErrorReporter reporter) {
        this.reporter = reporter;
    }

    public void invokePostEvent(PacketEvent event, NetworkMarker marker) {
        if (marker == null) {
            return;
        }
        if (event != null && NetworkMarker.hasPostListeners(marker)) {
            for (PacketPostListener listener : marker.getPostListeners()) {
                try {
                    listener.onPostEvent(event);
                }
                catch (OutOfMemoryError | ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.reporter.reportMinimal(listener.getPlugin(), "SentListener.run()", e);
                }
            }
        }
        this.sendScheduledPackets(marker);
    }

    private void sendScheduledPackets(NetworkMarker marker) {
        Set<ScheduledPacket> scheduled = NetworkMarker.readScheduledPackets(marker);
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        if (scheduled != null) {
            for (ScheduledPacket packet : scheduled) {
                packet.schedule(manager);
            }
        }
    }
}

