/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.AbstractStructure;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketMetadata;
import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.ObjectWriter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.cloning.AggregateCloner;
import com.comphenix.protocol.reflect.cloning.BukkitCloner;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.CollectionCloner;
import com.comphenix.protocol.reflect.cloning.FieldCloner;
import com.comphenix.protocol.reflect.cloning.GuavaOptionalCloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.JavaOptionalCloner;
import com.comphenix.protocol.reflect.cloning.SerializableCloner;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.MinecraftGenerator;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.Converters;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class PacketContainer
extends AbstractStructure
implements Serializable {
    private static final long serialVersionUID = 3L;
    private PacketType type;
    private static ConcurrentMap<Class<?>, Method> writeMethods = Maps.newConcurrentMap();
    private static ConcurrentMap<Class<?>, Method> readMethods = Maps.newConcurrentMap();
    private static final AggregateCloner DEEP_CLONER = AggregateCloner.newBuilder().instanceProvider(StructureCache::newPacket).andThen(BukkitCloner.class).andThen(ImmutableDetector.class).andThen(JavaOptionalCloner.class).andThen(GuavaOptionalCloner.class).andThen(CollectionCloner.class).andThen(PacketContainer.getSpecializedDeepClonerFactory()).build();
    private static final AggregateCloner SHALLOW_CLONER = AggregateCloner.newBuilder().instanceProvider(StructureCache::newPacket).andThen((Function<AggregateCloner.BuilderParameters, Cloner>)((Function)param -> {
        if (param == null) {
            throw new IllegalArgumentException("Cannot be NULL.");
        }
        return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
            {
                this.writer = new ObjectWriter();
            }
        };
    })).build();
    private static final Set<PacketType> FAST_CLONE_UNSUPPORTED = Sets.newHashSet((Object[])new PacketType[]{PacketType.Play.Server.BOSS, PacketType.Play.Server.ADVANCEMENTS, PacketType.Play.Client.USE_ENTITY, PacketType.Status.Server.SERVER_INFO});

    public PacketContainer(PacketType type) {
        this(type, StructureCache.newPacket(type));
    }

    public PacketContainer(PacketType type, Object handle) {
        this(type, handle, StructureCache.getStructure(type).withTarget(handle));
    }

    public PacketContainer(PacketType type, Object handle, StructureModifier<Object> structure) {
        super(handle, structure);
        this.type = type;
        this.setDefaults();
    }

    private void setDefaults() {
        if (MinecraftVersion.NETHER_UPDATE.atOrAbove() && this.type == PacketType.Play.Server.CHAT && !this.getUUIDs().optionRead(0).isPresent()) {
            this.getUUIDs().writeSafely(0, MinecraftGenerator.SYS_UUID);
        }
    }

    public static PacketContainer fromPacket(Object packet) {
        PacketType type = PacketType.fromClass(packet.getClass());
        return new PacketContainer(type, packet);
    }

    protected PacketContainer() {
    }

    @Override
    public Object getHandle() {
        return this.handle;
    }

    @Override
    public StructureModifier<Object> getModifier() {
        return this.structureModifier;
    }

    public StructureModifier<InternalStructure> getStructures() {
        return this.structureModifier.withType(Object.class, InternalStructure.CONVERTER);
    }

    public StructureModifier<Optional<InternalStructure>> getOptionalStructures() {
        return this.structureModifier.withType(Optional.class, Converters.optional(InternalStructure.CONVERTER));
    }

    @Deprecated
    public int getId() {
        return this.type.getCurrentId();
    }

    public PacketType getType() {
        return this.type;
    }

    public PacketContainer shallowClone() {
        Object clonedPacket = SHALLOW_CLONER.clone(this.getHandle());
        return new PacketContainer(this.getType(), clonedPacket);
    }

    public PacketContainer deepClone() {
        Object clonedPacket = null;
        if (!FAST_CLONE_UNSUPPORTED.contains(this.type)) {
            try {
                clonedPacket = DEEP_CLONER.clone(this.getHandle());
            }
            catch (Exception ex) {
                FAST_CLONE_UNSUPPORTED.add(this.type);
            }
        }
        if (clonedPacket == null) {
            clonedPacket = SerializableCloner.clone(this).getHandle();
        }
        return new PacketContainer(this.getType(), clonedPacket);
    }

    private static Function<AggregateCloner.BuilderParameters, Cloner> getSpecializedDeepClonerFactory() {
        return new Function<AggregateCloner.BuilderParameters, Cloner>(){

            public Cloner apply(@Nullable AggregateCloner.BuilderParameters param) {
                return new FieldCloner(param.getAggregateCloner(), param.getInstanceProvider()){
                    {
                        super(defaultCloner, instanceProvider);
                        this.writer = new ObjectWriter(){

                            @Override
                            protected void transformField(StructureModifier<Object> modifierSource, StructureModifier<Object> modifierDest, int fieldIndex) {
                                if (modifierSource.getField(fieldIndex).getName().startsWith("inflatedBuffer")) {
                                    modifierDest.write(fieldIndex, modifierSource.read(fieldIndex));
                                } else {
                                    this.defaultTransform(modifierSource, modifierDest, this.getDefaultCloner(), fieldIndex);
                                }
                            }
                        };
                    }
                };
            }
        };
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeBoolean(this.handle != null);
        try {
            ByteBuf buffer = PacketContainer.createPacketBuffer();
            MinecraftMethods.getPacketWriteByteBufMethod().invoke(this.handle, buffer);
            output.writeInt(buffer.readableBytes());
            buffer.readBytes((OutputStream)output, buffer.readableBytes());
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Minecraft packet doesn't support DataOutputStream", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Insufficient security privileges.", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Could not serialize Minecraft packet.", e);
        }
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.structureModifier = StructureCache.getStructure(this.type);
        if (input.readBoolean()) {
            ByteBuf buffer = PacketContainer.createPacketBuffer();
            buffer.writeBytes((InputStream)input, input.readInt());
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                Object serializer = MinecraftReflection.getPacketDataSerializer(buffer);
                try {
                    this.handle = this.type.getPacketClass().getConstructor(MinecraftReflection.getPacketDataSerializerClass()).newInstance(serializer);
                }
                catch (ReflectiveOperationException ex) {
                    Method method = FuzzyReflection.fromClass(this.type.getPacketClass(), true).getMethod(FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(this.type.getPacketClass()).parameterExactArray(MinecraftReflection.getPacketDataSerializerClass()).build());
                    try {
                        this.handle = method.invoke(null, serializer);
                    }
                    catch (ReflectiveOperationException ignored) {
                        throw new RuntimeException("Failed to construct packet for " + this.type, ex);
                    }
                }
            } else {
                this.handle = StructureCache.newPacket(this.type);
                try {
                    MinecraftMethods.getPacketReadByteBufMethod().invoke(this.handle, buffer);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Minecraft packet doesn't support DataInputStream", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Insufficient security privileges.", e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException("Could not deserialize Minecraft packet.", e);
                }
            }
            this.structureModifier = this.structureModifier.withTarget(this.handle);
        }
    }

    public static ByteBuf createPacketBuffer() {
        ByteBuf buffer = UnpooledByteBufAllocator.DEFAULT.buffer();
        Class<?> packetSerializer = MinecraftReflection.getPacketDataSerializerClass();
        try {
            return (ByteBuf)packetSerializer.getConstructor(ByteBuf.class).newInstance(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot construct packet serializer.", e);
        }
    }

    public <T> Optional<T> getMeta(String key) {
        return PacketMetadata.get(this.handle, key);
    }

    public <T> void setMeta(String key, T value) {
        PacketMetadata.set(this.handle, key, value);
    }

    public void removeMeta(String key) {
        PacketMetadata.remove(this.handle, key);
    }

    private Method getMethodLazily(ConcurrentMap<Class<?>, Method> lookup, Class<?> handleClass, String methodName, Class<?> parameterClass) {
        Method initialized;
        Method method = (Method)lookup.get(handleClass);
        if (method == null && (method = lookup.putIfAbsent(handleClass, initialized = FuzzyReflection.fromClass(handleClass).getMethod(FuzzyMethodContract.newBuilder().parameterCount(1).parameterDerivedOf(parameterClass).returnTypeVoid().build()))) == null) {
            method = initialized;
        }
        return method;
    }

    public String toString() {
        return "PacketContainer[type=" + this.type + ", structureModifier=" + this.structureModifier + "]";
    }
}

