/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.GamePhase;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.plugin.Plugin;

public abstract class PacketAdapter
implements PacketListener {
    protected Plugin plugin;
    protected ConnectionSide connectionSide;
    protected ListeningWhitelist receivingWhitelist = ListeningWhitelist.EMPTY_WHITELIST;
    protected ListeningWhitelist sendingWhitelist = ListeningWhitelist.EMPTY_WHITELIST;

    public PacketAdapter(@Nonnull AdapterParameteters params) {
        this(PacketAdapter.checkValidity(params).plugin, params.connectionSide, params.listenerPriority, params.gamePhase, params.options, params.packets);
    }

    public PacketAdapter(Plugin plugin, PacketType ... types) {
        this(plugin, ListenerPriority.NORMAL, types);
    }

    public PacketAdapter(Plugin plugin, Iterable<? extends PacketType> types) {
        this(PacketAdapter.params(plugin, (PacketType[])Iterables.toArray(types, PacketType.class)));
    }

    public PacketAdapter(Plugin plugin, ListenerPriority listenerPriority, Iterable<? extends PacketType> types) {
        this(PacketAdapter.params(plugin, (PacketType[])Iterables.toArray(types, PacketType.class)).listenerPriority(listenerPriority));
    }

    public PacketAdapter(Plugin plugin, ListenerPriority listenerPriority, Iterable<? extends PacketType> types, ListenerOptions ... options) {
        this(PacketAdapter.params(plugin, (PacketType[])Iterables.toArray(types, PacketType.class)).listenerPriority(listenerPriority).options(options));
    }

    public PacketAdapter(Plugin plugin, ListenerPriority listenerPriority, PacketType ... types) {
        this(PacketAdapter.params(plugin, types).listenerPriority(listenerPriority));
    }

    private PacketAdapter(Plugin plugin, ConnectionSide connectionSide, ListenerPriority listenerPriority, GamePhase gamePhase, ListenerOptions[] options, PacketType ... packets) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        if (connectionSide == null) {
            throw new IllegalArgumentException("connectionSide cannot be null");
        }
        if (listenerPriority == null) {
            throw new IllegalArgumentException("listenerPriority cannot be null");
        }
        if (gamePhase == null) {
            throw new IllegalArgumentException("gamePhase cannot be NULL");
        }
        if (packets == null) {
            throw new IllegalArgumentException("packets cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null");
        }
        if (connectionSide.isForServer()) {
            this.sendingWhitelist = ListeningWhitelist.newBuilder().priority(listenerPriority).types(packets).gamePhase(gamePhase).options(options).build();
        }
        if (connectionSide.isForClient()) {
            this.receivingWhitelist = ListeningWhitelist.newBuilder().priority(listenerPriority).types(packets).gamePhase(gamePhase).options(options).build();
        }
        this.plugin = plugin;
        this.connectionSide = connectionSide;
    }

    public static String getPluginName(PacketListener listener) {
        return PacketAdapter.getPluginName(listener.getPlugin());
    }

    public static String getPluginName(Plugin plugin) {
        if (plugin == null) {
            return "UNKNOWN";
        }
        try {
            return plugin.getName();
        }
        catch (NoSuchMethodError e) {
            return plugin.toString();
        }
    }

    public static AdapterParameteters params() {
        return new AdapterParameteters();
    }

    public static AdapterParameteters params(Plugin plugin, PacketType ... packets) {
        return new AdapterParameteters().plugin(plugin).types(packets);
    }

    private static AdapterParameteters checkValidity(AdapterParameteters params) {
        if (params == null) {
            throw new IllegalArgumentException("params cannot be NULL.");
        }
        if (params.plugin == null) {
            throw new IllegalStateException("Plugin was never set in the parameters.");
        }
        if (params.connectionSide == null) {
            throw new IllegalStateException("Connection side was never set in the parameters.");
        }
        if (params.packets == null) {
            throw new IllegalStateException("Packet IDs was never set in the parameters.");
        }
        return params;
    }

    @Override
    public void onPacketReceiving(PacketEvent event) {
        throw new IllegalStateException("Override onPacketReceiving to get notifcations of received packets!");
    }

    @Override
    public void onPacketSending(PacketEvent event) {
        throw new IllegalStateException("Override onPacketSending to get notifcations of sent packets!");
    }

    @Override
    public ListeningWhitelist getReceivingWhitelist() {
        return this.receivingWhitelist;
    }

    @Override
    public ListeningWhitelist getSendingWhitelist() {
        return this.sendingWhitelist;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return String.format("PacketAdapter[plugin=%s, sending=%s, receiving=%s]", PacketAdapter.getPluginName(this), this.sendingWhitelist, this.receivingWhitelist);
    }

    public static class AdapterParameteters {
        private Plugin plugin;
        private ConnectionSide connectionSide;
        private PacketType[] packets;
        private GamePhase gamePhase = GamePhase.PLAYING;
        private ListenerOptions[] options = new ListenerOptions[0];
        private ListenerPriority listenerPriority = ListenerPriority.NORMAL;

        public AdapterParameteters plugin(@Nonnull Plugin plugin) {
            this.plugin = (Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin cannot be NULL.");
            return this;
        }

        public AdapterParameteters connectionSide(@Nonnull ConnectionSide connectionSide) {
            this.connectionSide = (ConnectionSide)((Object)Preconditions.checkNotNull((Object)((Object)connectionSide), (Object)"connectionside cannot be NULL."));
            return this;
        }

        public AdapterParameteters clientSide() {
            return this.connectionSide(ConnectionSide.add(this.connectionSide, ConnectionSide.CLIENT_SIDE));
        }

        public AdapterParameteters serverSide() {
            return this.connectionSide(ConnectionSide.add(this.connectionSide, ConnectionSide.SERVER_SIDE));
        }

        public AdapterParameteters listenerPriority(@Nonnull ListenerPriority listenerPriority) {
            this.listenerPriority = (ListenerPriority)((Object)Preconditions.checkNotNull((Object)((Object)listenerPriority), (Object)"listener priority cannot be NULL."));
            return this;
        }

        public AdapterParameteters gamePhase(@Nonnull GamePhase gamePhase) {
            this.gamePhase = (GamePhase)((Object)Preconditions.checkNotNull((Object)((Object)gamePhase), (Object)"gamePhase cannot be NULL."));
            return this;
        }

        public AdapterParameteters loginPhase() {
            return this.gamePhase(GamePhase.LOGIN);
        }

        public AdapterParameteters options(ListenerOptions ... options) {
            this.options = (ListenerOptions[])Preconditions.checkNotNull((Object)options, (Object)"options cannot be NULL.");
            return this;
        }

        public AdapterParameteters options(@Nonnull Set<? extends ListenerOptions> options) {
            Preconditions.checkNotNull(options, (Object)"options cannot be NULL.");
            this.options = options.toArray(new ListenerOptions[0]);
            return this;
        }

        private AdapterParameteters addOption(ListenerOptions option) {
            if (this.options == null) {
                return this.options(option);
            }
            HashSet current = Sets.newHashSet((Object[])this.options);
            current.add(option);
            return this.options(current);
        }

        public AdapterParameteters optionAsync() {
            return this.addOption(ListenerOptions.ASYNC);
        }

        public AdapterParameteters types(PacketType ... packets) {
            if (this.connectionSide == null) {
                for (PacketType type : packets) {
                    this.connectionSide = ConnectionSide.add(this.connectionSide, type.getSender().toSide());
                }
            }
            this.packets = (PacketType[])Preconditions.checkNotNull((Object)packets, (Object)"packets cannot be NULL");
            if (packets.length == 0) {
                throw new IllegalArgumentException("Passed an empty packet type array.");
            }
            return this;
        }

        public AdapterParameteters types(@Nonnull Set<PacketType> packets) {
            return this.types(packets.toArray(new PacketType[0]));
        }
    }
}

