/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketPostListener;
import com.comphenix.protocol.events.ScheduledPacket;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class NetworkMarker {
    private final PacketType type;
    private final ConnectionSide side;
    private Set<PacketPostListener> postListeners;
    private Set<ScheduledPacket> scheduledPackets;

    public NetworkMarker(@Nonnull ConnectionSide side, PacketType type) {
        this.side = (ConnectionSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side cannot be NULL."));
        this.type = type;
    }

    public static boolean hasPostListeners(NetworkMarker marker) {
        return marker != null && !marker.getPostListeners().isEmpty();
    }

    public static NetworkMarker getNetworkMarker(PacketEvent event) {
        return event.networkMarker;
    }

    public static Set<ScheduledPacket> readScheduledPackets(NetworkMarker marker) {
        return marker.scheduledPackets;
    }

    public ConnectionSide getSide() {
        return this.side;
    }

    public PacketType getType() {
        return this.type;
    }

    public boolean addPostListener(PacketPostListener listener) {
        if (this.postListeners == null) {
            this.postListeners = new HashSet<PacketPostListener>();
        }
        return this.postListeners.add(listener);
    }

    public boolean removePostListener(PacketPostListener listener) {
        if (this.postListeners != null) {
            return this.postListeners.remove(listener);
        }
        return false;
    }

    public Set<PacketPostListener> getPostListeners() {
        return this.postListeners != null ? this.postListeners : Collections.emptySet();
    }

    public Set<ScheduledPacket> getScheduledPackets() {
        if (this.scheduledPackets == null) {
            this.scheduledPackets = new HashSet<ScheduledPacket>();
        }
        return this.scheduledPackets;
    }

    private void checkServerSide() {
        if (this.side.isForClient()) {
            throw new IllegalStateException("Must be a server side packet.");
        }
    }
}

