/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SortedCopyOnWriteArray<T extends Comparable<T>>
implements Collection<T> {
    private volatile List<T> list;

    public SortedCopyOnWriteArray() {
        this.list = new LinkedList<T>();
    }

    public SortedCopyOnWriteArray(Collection<T> wrapped) {
        this.list = new LinkedList<T>(wrapped);
    }

    public SortedCopyOnWriteArray(Collection<T> wrapped, boolean sort) {
        this.list = new ArrayList<T>(wrapped);
        if (sort) {
            Collections.sort(this.list);
        }
    }

    @Override
    public synchronized boolean add(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be NULL");
        }
        ArrayList<T> copy = new ArrayList<T>();
        for (Comparable element : this.list) {
            if (value != null && value.compareTo((Comparable)element) < 0) {
                copy.add(value);
                value = null;
            }
            copy.add(element);
        }
        if (value != null) {
            copy.add(value);
        }
        this.list = copy;
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> values) {
        if (values == null) {
            throw new IllegalArgumentException("values cannot be NULL");
        }
        if (values.size() == 0) {
            return false;
        }
        ArrayList<T> copy = new ArrayList<T>();
        copy.addAll(this.list);
        copy.addAll(values);
        Collections.sort(copy);
        this.list = copy;
        return true;
    }

    @Override
    public synchronized boolean remove(Object value) {
        ArrayList<T> copy = new ArrayList<T>();
        boolean result = false;
        for (Comparable element : this.list) {
            if (!Objects.equal((Object)value, (Object)element)) {
                copy.add(element);
                continue;
            }
            result = true;
        }
        this.list = copy;
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        if (values == null) {
            throw new IllegalArgumentException("values cannot be NULL");
        }
        if (values.size() == 0) {
            return false;
        }
        ArrayList<T> copy = new ArrayList<T>();
        copy.addAll(this.list);
        copy.removeAll(values);
        this.list = copy;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        if (values == null) {
            throw new IllegalArgumentException("values cannot be NULL");
        }
        if (values.size() == 0) {
            return false;
        }
        ArrayList<T> copy = new ArrayList<T>();
        copy.addAll(this.list);
        copy.removeAll(values);
        this.list = copy;
        return true;
    }

    public synchronized void remove(int index) {
        ArrayList<T> copy = new ArrayList<T>(this.list);
        copy.remove(index);
        this.list = copy;
    }

    public T get(int index) {
        return (T)((Comparable)this.list.get(index));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.unmodifiableIterable(this.list).iterator();
    }

    @Override
    public void clear() {
        this.list = new ArrayList<T>();
    }

    @Override
    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    @Override
    public boolean containsAll(Collection<?> values) {
        return this.list.containsAll(values);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }
}

