/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.comphenix.protocol.PacketType;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PacketTypeSet {
    private final Set<PacketType> types;
    private final Set<Class<?>> classes;

    public PacketTypeSet() {
        this.types = new HashSet<PacketType>(16, 0.9f);
        this.classes = new HashSet(16, 0.9f);
    }

    public PacketTypeSet(Collection<? extends PacketType> values) {
        this.types = new HashSet<PacketType>(values.size(), 0.9f);
        this.classes = new HashSet(values.size(), 0.9f);
        for (PacketType packetType : values) {
            this.addType(packetType);
        }
    }

    public void addType(PacketType type) {
        this.types.add(type);
        Class<?> packetClass = type.getPacketClass();
        if (packetClass != null) {
            this.classes.add(packetClass);
        }
    }

    public void addAll(Iterable<? extends PacketType> types) {
        for (PacketType packetType : types) {
            this.addType(packetType);
        }
    }

    public void removeType(PacketType type) {
        this.types.remove(type);
        Class<?> packetClass = type.getPacketClass();
        if (packetClass != null) {
            this.classes.remove(packetClass);
        }
    }

    public void removeAll(Iterable<? extends PacketType> types) {
        for (PacketType packetType : types) {
            this.removeType(packetType);
        }
    }

    public boolean contains(PacketType type) {
        return this.types.contains(type);
    }

    public boolean contains(Class<?> packetClass) {
        return this.classes.contains(packetClass);
    }

    public boolean containsPacket(Object packet) {
        return packet != null && this.classes.contains(packet.getClass());
    }

    public Set<PacketType> values() {
        return ImmutableSet.copyOf(this.types);
    }

    public int size() {
        return this.types.size();
    }

    public void clear() {
        this.types.clear();
        this.classes.clear();
    }
}

