/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationInvocationHandler;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy;
import sun.reflect.annotation.EnumConstantNotPresentExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.generics.tree.TypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class AnnotationParser {
    private static final Annotation[] EMPTY_ANNOTATIONS_ARRAY = new Annotation[0];
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    public static Map<Class<? extends Annotation>, Annotation> parseAnnotations(byte[] rawAnnotations, ConstantPool constPool, Class<?> container) {
        if (rawAnnotations == null) {
            return Collections.emptyMap();
        }
        try {
            return AnnotationParser.parseAnnotations2(rawAnnotations, constPool, container, null);
        }
        catch (BufferUnderflowException e) {
            throw new AnnotationFormatError("Unexpected end of annotations.");
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationFormatError(e);
        }
    }

    @SafeVarargs
    static Map<Class<? extends Annotation>, Annotation> parseSelectAnnotations(byte[] rawAnnotations, ConstantPool constPool, Class<?> container, Class<? extends Annotation> ... selectAnnotationClasses) {
        if (rawAnnotations == null) {
            return Collections.emptyMap();
        }
        try {
            return AnnotationParser.parseAnnotations2(rawAnnotations, constPool, container, selectAnnotationClasses);
        }
        catch (BufferUnderflowException e) {
            throw new AnnotationFormatError("Unexpected end of annotations.");
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationFormatError(e);
        }
    }

    private static Map<Class<? extends Annotation>, Annotation> parseAnnotations2(byte[] rawAnnotations, ConstantPool constPool, Class<?> container, Class<? extends Annotation>[] selectAnnotationClasses) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> result = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
        int numAnnotations = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numAnnotations; ++i) {
            Class<? extends Annotation> klass;
            Annotation a = AnnotationParser.parseAnnotation2(buf, constPool, container, false, selectAnnotationClasses);
            if (a == null || AnnotationType.getInstance(klass = a.annotationType()).retention() != RetentionPolicy.RUNTIME || result.put(klass, a) == null) continue;
            throw new AnnotationFormatError("Duplicate annotation for class: " + klass + ": " + a);
        }
        return result;
    }

    public static Annotation[][] parseParameterAnnotations(byte[] rawAnnotations, ConstantPool constPool, Class<?> container) {
        try {
            return AnnotationParser.parseParameterAnnotations2(rawAnnotations, constPool, container);
        }
        catch (BufferUnderflowException e) {
            throw new AnnotationFormatError("Unexpected end of parameter annotations.");
        }
        catch (IllegalArgumentException e) {
            throw new AnnotationFormatError(e);
        }
    }

    private static Annotation[][] parseParameterAnnotations2(byte[] rawAnnotations, ConstantPool constPool, Class<?> container) {
        ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
        int numParameters = buf.get() & 0xFF;
        Annotation[][] result = new Annotation[numParameters][];
        for (int i = 0; i < numParameters; ++i) {
            int numAnnotations = buf.getShort() & 0xFFFF;
            ArrayList<Annotation> annotations = new ArrayList<Annotation>(numAnnotations);
            for (int j = 0; j < numAnnotations; ++j) {
                AnnotationType type;
                Annotation a = AnnotationParser.parseAnnotation(buf, constPool, container, false);
                if (a == null || (type = AnnotationType.getInstance(a.annotationType())).retention() != RetentionPolicy.RUNTIME) continue;
                annotations.add(a);
            }
            result[i] = annotations.toArray(EMPTY_ANNOTATIONS_ARRAY);
        }
        return result;
    }

    private static Annotation parseAnnotation(ByteBuffer buf, ConstantPool constPool, Class<?> container, boolean exceptionOnMissingAnnotationClass) {
        return AnnotationParser.parseAnnotation2(buf, constPool, container, exceptionOnMissingAnnotationClass, null);
    }

    private static Annotation parseAnnotation2(ByteBuffer buf, ConstantPool constPool, Class<?> container, boolean exceptionOnMissingAnnotationClass, Class<? extends Annotation>[] selectAnnotationClasses) {
        int typeIndex = buf.getShort() & 0xFFFF;
        Class<?> annotationClass = null;
        String sig = "[unknown]";
        try {
            try {
                sig = constPool.getUTF8At(typeIndex);
                annotationClass = AnnotationParser.parseSig(sig, container);
            }
            catch (IllegalArgumentException ex) {
                annotationClass = constPool.getClassAt(typeIndex);
            }
        }
        catch (NoClassDefFoundError e) {
            if (exceptionOnMissingAnnotationClass) {
                throw new TypeNotPresentException(sig, e);
            }
            AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        catch (TypeNotPresentException e) {
            if (exceptionOnMissingAnnotationClass) {
                throw e;
            }
            AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        if (selectAnnotationClasses != null && !AnnotationParser.contains(selectAnnotationClasses, annotationClass)) {
            AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        AnnotationType type = null;
        try {
            type = AnnotationType.getInstance(annotationClass);
        }
        catch (IllegalArgumentException e) {
            AnnotationParser.skipAnnotation(buf, false);
            return null;
        }
        Map<String, Class<?>> memberTypes = type.memberTypes();
        LinkedHashMap<String, Object> memberValues = new LinkedHashMap<String, Object>(type.memberDefaults());
        int numMembers = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numMembers; ++i) {
            int memberNameIndex = buf.getShort() & 0xFFFF;
            String memberName = constPool.getUTF8At(memberNameIndex);
            Class<?> memberType = memberTypes.get(memberName);
            if (memberType == null) {
                AnnotationParser.skipMemberValue(buf);
                continue;
            }
            Object value = AnnotationParser.parseMemberValue(memberType, buf, constPool, container);
            if (value instanceof AnnotationTypeMismatchExceptionProxy) {
                ((AnnotationTypeMismatchExceptionProxy)value).setMember(type.members().get(memberName));
            }
            memberValues.put(memberName, value);
        }
        return AnnotationParser.annotationForMap(annotationClass, memberValues);
    }

    public static Annotation annotationForMap(Class<? extends Annotation> type, Map<String, Object> memberValues) {
        return (Annotation)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new AnnotationInvocationHandler(type, memberValues));
    }

    public static Object parseMemberValue(Class<?> memberType, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        Object result = null;
        byte tag = buf.get();
        switch (tag) {
            case 101: {
                return AnnotationParser.parseEnumValue(memberType, buf, constPool, container);
            }
            case 99: {
                result = AnnotationParser.parseClassValue(buf, constPool, container);
                break;
            }
            case 64: {
                result = AnnotationParser.parseAnnotation(buf, constPool, container, true);
                break;
            }
            case 91: {
                return AnnotationParser.parseArray(memberType, buf, constPool, container);
            }
            default: {
                result = AnnotationParser.parseConst(tag, buf, constPool);
            }
        }
        if (!(result instanceof ExceptionProxy) && !memberType.isInstance(result)) {
            result = new AnnotationTypeMismatchExceptionProxy(result.getClass() + "[" + result + "]");
        }
        return result;
    }

    private static Object parseConst(int tag, ByteBuffer buf, ConstantPool constPool) {
        int constIndex = buf.getShort() & 0xFFFF;
        switch (tag) {
            case 66: {
                return (byte)constPool.getIntAt(constIndex);
            }
            case 67: {
                return Character.valueOf((char)constPool.getIntAt(constIndex));
            }
            case 68: {
                return constPool.getDoubleAt(constIndex);
            }
            case 70: {
                return Float.valueOf(constPool.getFloatAt(constIndex));
            }
            case 73: {
                return constPool.getIntAt(constIndex);
            }
            case 74: {
                return constPool.getLongAt(constIndex);
            }
            case 83: {
                return (short)constPool.getIntAt(constIndex);
            }
            case 90: {
                return constPool.getIntAt(constIndex) != 0;
            }
            case 115: {
                return constPool.getUTF8At(constIndex);
            }
        }
        throw new AnnotationFormatError("Invalid member-value tag in annotation: " + tag);
    }

    private static Object parseClassValue(ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        int classIndex = buf.getShort() & 0xFFFF;
        try {
            try {
                String sig = constPool.getUTF8At(classIndex);
                return AnnotationParser.parseSig(sig, container);
            }
            catch (IllegalArgumentException ex) {
                return constPool.getClassAt(classIndex);
            }
        }
        catch (NoClassDefFoundError e) {
            return new TypeNotPresentExceptionProxy("[unknown]", e);
        }
        catch (TypeNotPresentException e) {
            return new TypeNotPresentExceptionProxy(e.typeName(), e.getCause());
        }
    }

    private static Class<?> parseSig(String sig, Class<?> container) {
        if (sig.equals("V")) {
            return Void.TYPE;
        }
        SignatureParser parser = SignatureParser.make();
        TypeSignature typeSig = parser.parseTypeSig(sig);
        CoreReflectionFactory factory = CoreReflectionFactory.make(container, ClassScope.make(container));
        Reifier reify = Reifier.make(factory);
        typeSig.accept(reify);
        Type result = reify.getResult();
        return AnnotationParser.toClass(result);
    }

    static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            return Array.newInstance(AnnotationParser.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
        }
        return (Class)o;
    }

    private static Object parseEnumValue(Class<? extends Enum> enumType, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        int typeNameIndex = buf.getShort() & 0xFFFF;
        String typeName = constPool.getUTF8At(typeNameIndex);
        int constNameIndex = buf.getShort() & 0xFFFF;
        String constName = constPool.getUTF8At(constNameIndex);
        if (!typeName.endsWith(";") ? !enumType.getName().equals(typeName) : enumType != AnnotationParser.parseSig(typeName, container)) {
            return new AnnotationTypeMismatchExceptionProxy(typeName + "." + constName);
        }
        try {
            return Enum.valueOf(enumType, constName);
        }
        catch (IllegalArgumentException e) {
            return new EnumConstantNotPresentExceptionProxy(enumType, constName);
        }
    }

    private static Object parseArray(Class<?> arrayType, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        int length = buf.getShort() & 0xFFFF;
        Class<?> componentType = arrayType.getComponentType();
        if (componentType == Byte.TYPE) {
            return AnnotationParser.parseByteArray(length, buf, constPool);
        }
        if (componentType == Character.TYPE) {
            return AnnotationParser.parseCharArray(length, buf, constPool);
        }
        if (componentType == Double.TYPE) {
            return AnnotationParser.parseDoubleArray(length, buf, constPool);
        }
        if (componentType == Float.TYPE) {
            return AnnotationParser.parseFloatArray(length, buf, constPool);
        }
        if (componentType == Integer.TYPE) {
            return AnnotationParser.parseIntArray(length, buf, constPool);
        }
        if (componentType == Long.TYPE) {
            return AnnotationParser.parseLongArray(length, buf, constPool);
        }
        if (componentType == Short.TYPE) {
            return AnnotationParser.parseShortArray(length, buf, constPool);
        }
        if (componentType == Boolean.TYPE) {
            return AnnotationParser.parseBooleanArray(length, buf, constPool);
        }
        if (componentType == String.class) {
            return AnnotationParser.parseStringArray(length, buf, constPool);
        }
        if (componentType == Class.class) {
            return AnnotationParser.parseClassArray(length, buf, constPool, container);
        }
        if (componentType.isEnum()) {
            return AnnotationParser.parseEnumArray(length, componentType, buf, constPool, container);
        }
        assert (componentType.isAnnotation());
        return AnnotationParser.parseAnnotationArray(length, componentType, buf, constPool, container);
    }

    private static Object parseByteArray(int length, ByteBuffer buf, ConstantPool constPool) {
        byte[] result = new byte[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 66) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = (byte)constPool.getIntAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseCharArray(int length, ByteBuffer buf, ConstantPool constPool) {
        char[] result = new char[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 67) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = (char)constPool.getIntAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseDoubleArray(int length, ByteBuffer buf, ConstantPool constPool) {
        double[] result = new double[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 68) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getDoubleAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseFloatArray(int length, ByteBuffer buf, ConstantPool constPool) {
        float[] result = new float[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 70) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getFloatAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseIntArray(int length, ByteBuffer buf, ConstantPool constPool) {
        int[] result = new int[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 73) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getIntAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseLongArray(int length, ByteBuffer buf, ConstantPool constPool) {
        long[] result = new long[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 74) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getLongAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseShortArray(int length, ByteBuffer buf, ConstantPool constPool) {
        short[] result = new short[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 83) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = (short)constPool.getIntAt(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseBooleanArray(int length, ByteBuffer buf, ConstantPool constPool) {
        boolean[] result = new boolean[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 90) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getIntAt(index) != 0;
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? (Object)AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseStringArray(int length, ByteBuffer buf, ConstantPool constPool) {
        String[] result = new String[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 115) {
                int index = buf.getShort() & 0xFFFF;
                result[i] = constPool.getUTF8At(index);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseClassArray(int length, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        Class[] result = new Class[length];
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 99) {
                result[i] = AnnotationParser.parseClassValue(buf, constPool, container);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseEnumArray(int length, Class<? extends Enum> enumType, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        Object[] result = (Object[])Array.newInstance(enumType, length);
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 101) {
                result[i] = AnnotationParser.parseEnumValue(enumType, buf, constPool, container);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? AnnotationParser.exceptionProxy(tag) : result;
    }

    private static Object parseAnnotationArray(int length, Class<? extends Annotation> annotationType, ByteBuffer buf, ConstantPool constPool, Class<?> container) {
        Object[] result = (Object[])Array.newInstance(annotationType, length);
        boolean typeMismatch = false;
        byte tag = 0;
        for (int i = 0; i < length; ++i) {
            tag = buf.get();
            if (tag == 64) {
                result[i] = AnnotationParser.parseAnnotation(buf, constPool, container, true);
                continue;
            }
            AnnotationParser.skipMemberValue(tag, buf);
            typeMismatch = true;
        }
        return typeMismatch ? AnnotationParser.exceptionProxy(tag) : result;
    }

    private static ExceptionProxy exceptionProxy(int tag) {
        return new AnnotationTypeMismatchExceptionProxy("Array with component tag: " + tag);
    }

    private static void skipAnnotation(ByteBuffer buf, boolean complete) {
        if (complete) {
            buf.getShort();
        }
        int numMembers = buf.getShort() & 0xFFFF;
        for (int i = 0; i < numMembers; ++i) {
            buf.getShort();
            AnnotationParser.skipMemberValue(buf);
        }
    }

    private static void skipMemberValue(ByteBuffer buf) {
        byte tag = buf.get();
        AnnotationParser.skipMemberValue(tag, buf);
    }

    private static void skipMemberValue(int tag, ByteBuffer buf) {
        switch (tag) {
            case 101: {
                buf.getInt();
                break;
            }
            case 64: {
                AnnotationParser.skipAnnotation(buf, true);
                break;
            }
            case 91: {
                AnnotationParser.skipArray(buf);
                break;
            }
            default: {
                buf.getShort();
            }
        }
    }

    private static void skipArray(ByteBuffer buf) {
        int length = buf.getShort() & 0xFFFF;
        for (int i = 0; i < length; ++i) {
            AnnotationParser.skipMemberValue(buf);
        }
    }

    private static boolean contains(Object[] array, Object element) {
        for (Object e : array) {
            if (e != element) continue;
            return true;
        }
        return false;
    }

    public static Annotation[] toArray(Map<Class<? extends Annotation>, Annotation> annotations) {
        return annotations.values().toArray(EMPTY_ANNOTATION_ARRAY);
    }
}

