/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.editors;

import ajava.beans.PropertyChangeEvent;
import ajava.beans.PropertyChangeListener;
import ajava.beans.PropertyEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class EnumEditor
implements PropertyEditor {
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final Class type;
    private final String[] tags;
    private Object value;

    public EnumEditor(Class type) {
        T[] values = type.getEnumConstants();
        if (values == null) {
            throw new IllegalArgumentException("Unsupported " + type);
        }
        this.type = type;
        this.tags = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.tags[i] = ((Enum)values[i]).name();
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        PropertyChangeListener[] listeners;
        Object oldValue;
        if (value != null && !this.type.isInstance(value)) {
            throw new IllegalArgumentException("Unsupported value: " + value);
        }
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            oldValue = this.value;
            this.value = value;
            if (value == null ? oldValue == null : value.equals(oldValue)) {
                return;
            }
            int size = this.listeners.size();
            if (size == 0) {
                return;
            }
            listeners = this.listeners.toArray(new PropertyChangeListener[size]);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, null, oldValue, value);
        for (PropertyChangeListener listener : listeners) {
            listener.propertyChange(event);
        }
    }

    @Override
    public String getAsText() {
        return this.value != null ? ((Enum)this.value).name() : null;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text != null ? Enum.valueOf(this.type, text) : null);
    }

    @Override
    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    @Override
    public String getJavaInitializationString() {
        String name = this.getAsText();
        return name != null ? this.type.getName() + '.' + name : "null";
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

