/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import ajava.beans.ExceptionListener;
import com.sun.beans.decoder.ArrayElementHandler;
import com.sun.beans.decoder.BooleanElementHandler;
import com.sun.beans.decoder.ByteElementHandler;
import com.sun.beans.decoder.CharElementHandler;
import com.sun.beans.decoder.ClassElementHandler;
import com.sun.beans.decoder.DoubleElementHandler;
import com.sun.beans.decoder.ElementHandler;
import com.sun.beans.decoder.FalseElementHandler;
import com.sun.beans.decoder.FieldElementHandler;
import com.sun.beans.decoder.FloatElementHandler;
import com.sun.beans.decoder.IntElementHandler;
import com.sun.beans.decoder.JavaElementHandler;
import com.sun.beans.decoder.LongElementHandler;
import com.sun.beans.decoder.MethodElementHandler;
import com.sun.beans.decoder.NewElementHandler;
import com.sun.beans.decoder.NullElementHandler;
import com.sun.beans.decoder.ObjectElementHandler;
import com.sun.beans.decoder.PropertyElementHandler;
import com.sun.beans.decoder.ShortElementHandler;
import com.sun.beans.decoder.StringElementHandler;
import com.sun.beans.decoder.TrueElementHandler;
import com.sun.beans.decoder.VarElementHandler;
import com.sun.beans.decoder.VoidElementHandler;
import com.sun.beans.finder.ClassFinder;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sun.misc.SharedSecrets;

public final class DocumentHandler
extends DefaultHandler {
    private final AccessControlContext acc = AccessController.getContext();
    private final Map<String, Class<? extends ElementHandler>> handlers = new HashMap<String, Class<? extends ElementHandler>>();
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final List<Object> objects = new ArrayList<Object>();
    private Reference<ClassLoader> loader;
    private ExceptionListener listener;
    private Object owner;
    private ElementHandler handler;

    public DocumentHandler() {
        this.setElementHandler("java", JavaElementHandler.class);
        this.setElementHandler("null", NullElementHandler.class);
        this.setElementHandler("array", ArrayElementHandler.class);
        this.setElementHandler("class", ClassElementHandler.class);
        this.setElementHandler("string", StringElementHandler.class);
        this.setElementHandler("object", ObjectElementHandler.class);
        this.setElementHandler("void", VoidElementHandler.class);
        this.setElementHandler("char", CharElementHandler.class);
        this.setElementHandler("byte", ByteElementHandler.class);
        this.setElementHandler("short", ShortElementHandler.class);
        this.setElementHandler("int", IntElementHandler.class);
        this.setElementHandler("long", LongElementHandler.class);
        this.setElementHandler("float", FloatElementHandler.class);
        this.setElementHandler("double", DoubleElementHandler.class);
        this.setElementHandler("boolean", BooleanElementHandler.class);
        this.setElementHandler("new", NewElementHandler.class);
        this.setElementHandler("var", VarElementHandler.class);
        this.setElementHandler("true", TrueElementHandler.class);
        this.setElementHandler("false", FalseElementHandler.class);
        this.setElementHandler("field", FieldElementHandler.class);
        this.setElementHandler("method", MethodElementHandler.class);
        this.setElementHandler("property", PropertyElementHandler.class);
    }

    public ClassLoader getClassLoader() {
        return this.loader != null ? this.loader.get() : null;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = new WeakReference<ClassLoader>(loader);
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.listener = listener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Class<? extends ElementHandler> getElementHandler(String name) {
        Class<? extends ElementHandler> type = this.handlers.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unsupported element: " + name);
        }
        return type;
    }

    public void setElementHandler(String name, Class<? extends ElementHandler> handler) {
        this.handlers.put(name, handler);
    }

    public boolean hasVariable(String id) {
        return this.environment.containsKey(id);
    }

    public Object getVariable(String id) {
        if (!this.environment.containsKey(id)) {
            throw new IllegalArgumentException("Unbound variable: " + id);
        }
        return this.environment.get(id);
    }

    public void setVariable(String id, Object value) {
        this.environment.put(id, value);
    }

    public Object[] getObjects() {
        return this.objects.toArray();
    }

    void addObject(Object object) {
        this.objects.add(object);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startDocument() {
        this.objects.clear();
        this.handler = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ElementHandler parent = this.handler;
        try {
            this.handler = this.getElementHandler(qName).newInstance();
            this.handler.setOwner(this);
            this.handler.setParent(parent);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            try {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.handler.addAttribute(name, value);
                continue;
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
        }
        this.handler.startElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        try {
            this.handler.endElement();
        }
        catch (RuntimeException exception) {
            this.handleException(exception);
        }
        finally {
            this.handler = this.handler.getParent();
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (this.handler != null) {
            try {
                while (0 < length--) {
                    this.handler.addCharacter(chars[start++]);
                }
            }
            catch (RuntimeException exception) {
                this.handleException(exception);
            }
        }
    }

    public void handleException(Exception exception) {
        if (this.listener == null) {
            throw new IllegalStateException(exception);
        }
        this.listener.exceptionThrown(exception);
    }

    public void parse(final InputSource input) {
        if (this.acc == null && null != System.getSecurityManager()) {
            throw new SecurityException("AccessControlContext is not set");
        }
        AccessControlContext stack = AccessController.getContext();
        SharedSecrets.getJavaSecurityAccess().doIntersectionPrivilege((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    SAXParserFactory.newInstance().newSAXParser().parse(input, (DefaultHandler)DocumentHandler.this);
                }
                catch (ParserConfigurationException exception) {
                    DocumentHandler.this.handleException(exception);
                }
                catch (SAXException wrapper) {
                    Exception exception = wrapper.getException();
                    if (exception == null) {
                        exception = wrapper;
                    }
                    DocumentHandler.this.handleException(exception);
                }
                catch (IOException exception) {
                    DocumentHandler.this.handleException(exception);
                }
                return null;
            }
        }, stack, this.acc);
    }

    public Class<?> findClass(String name) {
        try {
            return ClassFinder.resolveClass(name, this.getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            this.handleException(exception);
            return null;
        }
    }
}

