/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans;

import ajava.beans.PropertyChangeEvent;
import ajava.beans.PropertyChangeListener;
import ajava.beans.PropertyEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class PropertyEditorSupport
implements PropertyEditor {
    private Object value;
    private Object source;
    private Vector listeners;

    public PropertyEditorSupport() {
        this.setSource(this);
    }

    public PropertyEditorSupport(Object source) {
        if (source == null) {
            throw new NullPointerException();
        }
        this.setSource(source);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    @Override
    public String getAsText() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (this.value instanceof String) {
            this.setValue(text);
            return;
        }
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector targets;
        PropertyEditorSupport propertyEditorSupport = this;
        synchronized (propertyEditorSupport) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.source, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }
}

