/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans;

import ajava.beans.Encoder;
import ajava.beans.Expression;

public abstract class PersistenceDelegate {
    public void writeObject(Object oldInstance, Encoder out) {
        Object newInstance = out.get(oldInstance);
        if (!this.mutatesTo(oldInstance, newInstance)) {
            out.remove(oldInstance);
            out.writeExpression(this.instantiate(oldInstance, out));
        } else {
            this.initialize(oldInstance.getClass(), oldInstance, newInstance, out);
        }
    }

    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
    }

    protected abstract Expression instantiate(Object var1, Encoder var2);

    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        Class<?> superType = type.getSuperclass();
        PersistenceDelegate info = out.getPersistenceDelegate(superType);
        info.initialize(superType, oldInstance, newInstance, out);
    }
}

