/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans;

import ajava.beans.ConstructorProperties;
import ajava.beans.NameGenerator;
import ajava.beans.Statement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.reflect.misc.MethodUtil;

public class EventHandler
implements InvocationHandler {
    private Object target;
    private String action;
    private final String eventPropertyName;
    private final String listenerMethodName;
    private final AccessControlContext acc = AccessController.getContext();

    @ConstructorProperties(value={"target", "action", "eventPropertyName", "listenerMethodName"})
    public EventHandler(Object target, String action, String eventPropertyName, String listenerMethodName) {
        this.target = target;
        this.action = action;
        if (target == null) {
            throw new NullPointerException("target must be non-null");
        }
        if (action == null) {
            throw new NullPointerException("action must be non-null");
        }
        this.eventPropertyName = eventPropertyName;
        this.listenerMethodName = listenerMethodName;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getAction() {
        return this.action;
    }

    public String getEventPropertyName() {
        return this.eventPropertyName;
    }

    public String getListenerMethodName() {
        return this.listenerMethodName;
    }

    private Object applyGetters(Object target, String getters) {
        if (getters == null || getters.equals("")) {
            return target;
        }
        int firstDot = getters.indexOf(46);
        if (firstDot == -1) {
            firstDot = getters.length();
        }
        String first = getters.substring(0, firstDot);
        String rest = getters.substring(Math.min(firstDot + 1, getters.length()));
        try {
            Method getter = null;
            if (target != null) {
                getter = Statement.getMethod(target.getClass(), "get" + NameGenerator.capitalize(first), new Class[0]);
                if (getter == null) {
                    getter = Statement.getMethod(target.getClass(), "is" + NameGenerator.capitalize(first), new Class[0]);
                }
                if (getter == null) {
                    getter = Statement.getMethod(target.getClass(), first, new Class[0]);
                }
            }
            if (getter == null) {
                throw new RuntimeException("No method called: " + first + " defined on " + target);
            }
            Object newTarget = MethodUtil.invoke(getter, target, new Object[0]);
            return this.applyGetters(newTarget, rest);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call method: " + first + " on " + target, e);
        }
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] arguments) {
        AccessControlContext acc = this.acc;
        if (acc == null && System.getSecurityManager() != null) {
            throw new SecurityException("AccessControlContext is not set");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return EventHandler.this.invokeInternal(proxy, method, arguments);
            }
        }, acc);
    }

    private Object invokeInternal(Object proxy, Method method, Object[] arguments) {
        String methodName = method.getName();
        if (method.getDeclaringClass() == Object.class) {
            if (methodName.equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (methodName.equals("equals")) {
                return proxy == arguments[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("toString")) {
                return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
            }
        }
        if (this.listenerMethodName == null || this.listenerMethodName.equals(methodName)) {
            Class[] argTypes = null;
            Object[] newArgs = null;
            if (this.eventPropertyName == null) {
                newArgs = new Object[]{};
                argTypes = new Class[]{};
            } else {
                Object input = this.applyGetters(arguments[0], this.getEventPropertyName());
                newArgs = new Object[]{input};
                argTypes = new Class[]{input == null ? null : input.getClass()};
            }
            try {
                Method targetMethod;
                int lastDot = this.action.lastIndexOf(46);
                if (lastDot != -1) {
                    this.target = this.applyGetters(this.target, this.action.substring(0, lastDot));
                    this.action = this.action.substring(lastDot + 1);
                }
                if ((targetMethod = Statement.getMethod(this.target.getClass(), this.action, argTypes)) == null) {
                    targetMethod = Statement.getMethod(this.target.getClass(), "set" + NameGenerator.capitalize(this.action), argTypes);
                }
                if (targetMethod == null) {
                    String argTypeString = argTypes.length == 0 ? " with no arguments" : " with argument " + argTypes[0];
                    throw new RuntimeException("No method called " + this.action + " on " + this.target.getClass() + argTypeString);
                }
                return MethodUtil.invoke(targetMethod, this.target, newArgs);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable th = ex.getTargetException();
                throw th instanceof RuntimeException ? (RuntimeException)th : new RuntimeException(th);
            }
        }
        return null;
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action) {
        return EventHandler.create(listenerInterface, target, action, null, null);
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action, String eventPropertyName) {
        return EventHandler.create(listenerInterface, target, action, eventPropertyName, null);
    }

    public static <T> T create(Class<T> listenerInterface, Object target, String action, String eventPropertyName, String listenerMethodName) {
        EventHandler eventHandler = new EventHandler(target, action, eventPropertyName, listenerMethodName);
        if (listenerInterface == null) {
            throw new NullPointerException("listenerInterface must be non-null");
        }
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)eventHandler);
    }
}

