/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.messages;

import com.cryptomorin.xseries.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public final class Titles
implements Cloneable {
    private static final Object TITLE;
    private static final Object SUBTITLE;
    private static final Object TIMES;
    private static final Object CLEAR;
    private static final MethodHandle PACKET_PLAY_OUT_TITLE;
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private String title;
    private String subtitle;
    private final int fadeIn;
    private final int stay;
    private final int fadeOut;

    public Titles(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    public Titles clone() {
        return new Titles(this.title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    public void send(Player player) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, this.title, this.subtitle);
    }

    public static void sendTitle(@Nonnull Player player, int fadeIn, int stay, int fadeOut, @Nullable String title, @Nullable String subtitle) {
        Objects.requireNonNull(player, "Cannot send title to null player");
        if (title == null && subtitle == null) {
            return;
        }
        if (ReflectionUtils.supports(11)) {
            player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
            return;
        }
        try {
            Object timesPacket = PACKET_PLAY_OUT_TITLE.invoke(TIMES, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
            ReflectionUtils.sendPacket(player, timesPacket);
            if (title != null) {
                Object titlePacket = PACKET_PLAY_OUT_TITLE.invoke(TITLE, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
                ReflectionUtils.sendPacket(player, titlePacket);
            }
            if (subtitle != null) {
                Object subtitlePacket = PACKET_PLAY_OUT_TITLE.invoke(SUBTITLE, CHAT_COMPONENT_TEXT.invoke(subtitle), fadeIn, stay, fadeOut);
                ReflectionUtils.sendPacket(player, subtitlePacket);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendTitle(@Nonnull Player player, @Nonnull String title, @Nonnull String subtitle) {
        Titles.sendTitle(player, 10, 20, 10, title, subtitle);
    }

    public static Titles sendTitle(@Nonnull Player player, @Nonnull ConfigurationSection config) {
        Titles titles = Titles.parseTitle(config, null);
        titles.send(player);
        return titles;
    }

    public static Titles parseTitle(@Nonnull ConfigurationSection config) {
        return Titles.parseTitle(config, null);
    }

    public static Titles parseTitle(@Nonnull ConfigurationSection config, @Nullable Function<String, String> transformers) {
        String title = config.getString("title");
        String subtitle = config.getString("subtitle");
        if (transformers != null) {
            title = transformers.apply(title);
            subtitle = transformers.apply(subtitle);
        }
        int fadeIn = config.getInt("fade-in");
        int stay = config.getInt("stay");
        int fadeOut = config.getInt("fade-out");
        if (fadeIn < 1) {
            fadeIn = 10;
        }
        if (stay < 1) {
            stay = 20;
        }
        if (fadeOut < 1) {
            fadeOut = 10;
        }
        return new Titles(title, subtitle, fadeIn, stay, fadeOut);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public static void clearTitle(@Nonnull Player player) {
        Object clearPacket;
        Objects.requireNonNull(player, "Cannot clear title from null player");
        if (ReflectionUtils.supports(11)) {
            player.resetTitle();
            return;
        }
        try {
            clearPacket = PACKET_PLAY_OUT_TITLE.invoke(CLEAR, null, -1, -1, -1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        ReflectionUtils.sendPacket(player, clearPacket);
    }

    public static void sendTabList(@Nonnull String header, @Nonnull String footer, Player ... players) {
        Objects.requireNonNull(players, "Cannot send tab title to null players");
        Objects.requireNonNull(header, "Tab title header cannot be null");
        Objects.requireNonNull(footer, "Tab title footer cannot be null");
        if (ReflectionUtils.supports(13)) {
            for (Player player : players) {
                player.setPlayerListHeaderFooter(header, footer);
            }
            return;
        }
        try {
            Class<?> IChatBaseComponent = ReflectionUtils.getNMSClass("network.chat", "IChatBaseComponent");
            Class<?> PacketPlayOutPlayerListHeaderFooter = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutPlayerListHeaderFooter");
            Method chatComponentBuilderMethod = IChatBaseComponent.getDeclaredClasses()[0].getMethod("a", String.class);
            Object tabHeader = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + header + "\"}");
            Object tabFooter = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + footer + "\"}");
            Object packet = PacketPlayOutPlayerListHeaderFooter.getConstructor(new Class[0]).newInstance(new Object[0]);
            Field headerField = PacketPlayOutPlayerListHeaderFooter.getDeclaredField("a");
            Field footerField = PacketPlayOutPlayerListHeaderFooter.getDeclaredField("b");
            headerField.setAccessible(true);
            headerField.set(packet, tabHeader);
            footerField.setAccessible(true);
            footerField.set(packet, tabFooter);
            for (Player player : players) {
                ReflectionUtils.sendPacket(player, packet);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        MethodHandle packetCtor = null;
        MethodHandle chatComp = null;
        Object times = null;
        Object title = null;
        Object subtitle = null;
        Object clear = null;
        if (!ReflectionUtils.supports(11)) {
            Class<?> chatComponentText = ReflectionUtils.getNMSClass("ChatComponentText");
            Class<?> packet = ReflectionUtils.getNMSClass("PacketPlayOutTitle");
            Class<?> titleTypes = packet.getDeclaredClasses()[0];
            block14: for (Object type : titleTypes.getEnumConstants()) {
                switch (type.toString()) {
                    case "TIMES": {
                        times = type;
                        continue block14;
                    }
                    case "TITLE": {
                        title = type;
                        continue block14;
                    }
                    case "SUBTITLE": {
                        subtitle = type;
                        continue block14;
                    }
                    case "CLEAR": {
                        clear = type;
                    }
                }
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                chatComp = lookup.findConstructor(chatComponentText, MethodType.methodType(Void.TYPE, String.class));
                packetCtor = lookup.findConstructor(packet, MethodType.methodType(Void.TYPE, titleTypes, ReflectionUtils.getNMSClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        TITLE = title;
        SUBTITLE = subtitle;
        TIMES = times;
        CLEAR = clear;
        PACKET_PLAY_OUT_TITLE = packetCtor;
        CHAT_COMPONENT_TEXT = chatComp;
    }
}

