/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XMaterial;
import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;

public enum XBiome {
    WINDSWEPT_HILLS("MOUNTAINS", "EXTREME_HILLS"),
    SNOWY_PLAINS("SNOWY_TUNDRA", "ICE_FLATS", "ICE_PLAINS"),
    SPARSE_JUNGLE("JUNGLE_EDGE", "JUNGLE_EDGE"),
    STONY_SHORE("STONE_SHORE", "STONE_BEACH"),
    CHERRY_GROVE(new String[0]),
    OLD_GROWTH_PINE_TAIGA("GIANT_TREE_TAIGA", "REDWOOD_TAIGA", "MEGA_TAIGA"),
    WINDSWEPT_FOREST("WOODED_MOUNTAINS", "EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_PLUS"),
    WOODED_BADLANDS("WOODED_BADLANDS_PLATEAU", "MESA_ROCK", "MESA_PLATEAU_FOREST"),
    WINDSWEPT_GRAVELLY_HILLS("GRAVELLY_MOUNTAINS", "MUTATED_EXTREME_HILLS", "EXTREME_HILLS_MOUNTAINS"),
    OLD_GROWTH_BIRCH_FOREST("TALL_BIRCH_FOREST", "MUTATED_BIRCH_FOREST", "BIRCH_FOREST_MOUNTAINS"),
    OLD_GROWTH_SPRUCE_TAIGA("GIANT_SPRUCE_TAIGA", "MUTATED_REDWOOD_TAIGA", "MEGA_SPRUCE_TAIGA"),
    WINDSWEPT_SAVANNA("SHATTERED_SAVANNA", "MUTATED_SAVANNA", "SAVANNA_MOUNTAINS"),
    MEADOW(new String[0]),
    MANGROVE_SWAMP(new String[0]),
    DEEP_DARK(new String[0]),
    GROVE(new String[0]),
    SNOWY_SLOPES(new String[0]),
    FROZEN_PEAKS(new String[0]),
    JAGGED_PEAKS(new String[0]),
    STONY_PEAKS(new String[0]),
    CUSTOM(new String[0]),
    BADLANDS("MESA"),
    BADLANDS_PLATEAU(WOODED_BADLANDS, "MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    BEACH("BEACHES"),
    BIRCH_FOREST(OLD_GROWTH_BIRCH_FOREST, "BIRCH_FOREST"),
    BIRCH_FOREST_HILLS(OLD_GROWTH_BIRCH_FOREST, "BIRCH_FOREST_HILLS"),
    COLD_OCEAN("COLD_OCEAN"),
    DARK_FOREST("ROOFED_FOREST"),
    DARK_FOREST_HILLS("MUTATED_ROOFED_FOREST", "ROOFED_FOREST_MOUNTAINS"),
    DEEP_COLD_OCEAN("COLD_DEEP_OCEAN"),
    DEEP_FROZEN_OCEAN("FROZEN_DEEP_OCEAN"),
    DEEP_LUKEWARM_OCEAN("LUKEWARM_DEEP_OCEAN"),
    DEEP_OCEAN("DEEP_OCEAN"),
    DEEP_WARM_OCEAN("WARM_DEEP_OCEAN"),
    DESERT("DESERT"),
    DESERT_HILLS("DESERT_HILLS"),
    DESERT_LAKES("MUTATED_DESERT", "DESERT_MOUNTAINS"),
    END_BARRENS(World.Environment.THE_END, "SKY_ISLAND_BARREN"),
    END_HIGHLANDS(World.Environment.THE_END, "SKY_ISLAND_HIGH"),
    END_MIDLANDS(World.Environment.THE_END, "SKY_ISLAND_MEDIUM"),
    ERODED_BADLANDS("MUTATED_MESA", "MESA_BRYCE"),
    FLOWER_FOREST("MUTATED_FOREST"),
    FOREST("FOREST"),
    FROZEN_OCEAN("FROZEN_OCEAN"),
    FROZEN_RIVER("FROZEN_RIVER"),
    GIANT_SPRUCE_TAIGA(OLD_GROWTH_SPRUCE_TAIGA, "MUTATED_REDWOOD_TAIGA", "MEGA_SPRUCE_TAIGA"),
    GIANT_SPRUCE_TAIGA_HILLS(OLD_GROWTH_SPRUCE_TAIGA, "MUTATED_REDWOOD_TAIGA_HILLS", "MEGA_SPRUCE_TAIGA_HILLS"),
    GIANT_TREE_TAIGA(OLD_GROWTH_PINE_TAIGA, "REDWOOD_TAIGA", "MEGA_TAIGA"),
    GIANT_TREE_TAIGA_HILLS(OLD_GROWTH_PINE_TAIGA, "REDWOOD_TAIGA_HILLS", "MEGA_TAIGA_HILLS"),
    ICE_SPIKES("MUTATED_ICE_FLATS", "ICE_PLAINS_SPIKES"),
    JUNGLE("JUNGLE"),
    JUNGLE_HILLS("JUNGLE_HILLS"),
    LUKEWARM_OCEAN("LUKEWARM_OCEAN"),
    MODIFIED_BADLANDS_PLATEAU(WOODED_BADLANDS, "MUTATED_MESA_CLEAR_ROCK", "MESA_PLATEAU"),
    MODIFIED_GRAVELLY_MOUNTAINS(WINDSWEPT_GRAVELLY_HILLS, "MUTATED_EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_MOUNTAINS"),
    MODIFIED_JUNGLE("MUTATED_JUNGLE", "JUNGLE_MOUNTAINS"),
    MODIFIED_JUNGLE_EDGE(SPARSE_JUNGLE, "MUTATED_JUNGLE_EDGE", "JUNGLE_EDGE_MOUNTAINS"),
    MODIFIED_WOODED_BADLANDS_PLATEAU(WOODED_BADLANDS, "MUTATED_MESA_ROCK", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    MOUNTAIN_EDGE(SPARSE_JUNGLE, "SMALLER_EXTREME_HILLS"),
    MUSHROOM_FIELDS("MUSHROOM_ISLAND"),
    MUSHROOM_FIELD_SHORE(STONY_SHORE, "MUSHROOM_ISLAND_SHORE", "MUSHROOM_SHORE"),
    SOUL_SAND_VALLEY(World.Environment.NETHER, new String[0]),
    CRIMSON_FOREST(World.Environment.NETHER, new String[0]),
    WARPED_FOREST(World.Environment.NETHER, new String[0]),
    BASALT_DELTAS(World.Environment.NETHER, new String[0]),
    NETHER_WASTES(World.Environment.NETHER, "NETHER", "HELL"),
    OCEAN("OCEAN"),
    PLAINS("PLAINS"),
    RIVER("RIVER"),
    SAVANNA("SAVANNA"),
    SAVANNA_PLATEAU(WINDSWEPT_SAVANNA, "SAVANNA_ROCK", "SAVANNA_PLATEAU"),
    SHATTERED_SAVANNA_PLATEAU(WINDSWEPT_SAVANNA, "MUTATED_SAVANNA_ROCK", "SAVANNA_PLATEAU_MOUNTAINS"),
    SMALL_END_ISLANDS(World.Environment.THE_END, "SKY_ISLAND_LOW"),
    SNOWY_BEACH("COLD_BEACH"),
    SNOWY_MOUNTAINS(WINDSWEPT_HILLS, "ICE_MOUNTAINS"),
    SNOWY_TAIGA("TAIGA_COLD", "COLD_TAIGA"),
    SNOWY_TAIGA_HILLS("TAIGA_COLD_HILLS", "COLD_TAIGA_HILLS"),
    SNOWY_TAIGA_MOUNTAINS(WINDSWEPT_FOREST, "MUTATED_TAIGA_COLD", "COLD_TAIGA_MOUNTAINS"),
    SUNFLOWER_PLAINS("MUTATED_PLAINS"),
    SWAMP("SWAMPLAND"),
    SWAMP_HILLS("MUTATED_SWAMPLAND", "SWAMPLAND_MOUNTAINS"),
    TAIGA("TAIGA"),
    TAIGA_HILLS("TAIGA_HILLS"),
    TAIGA_MOUNTAINS(WINDSWEPT_FOREST, "MUTATED_TAIGA"),
    TALL_BIRCH_FOREST(OLD_GROWTH_BIRCH_FOREST, "MUTATED_BIRCH_FOREST", "BIRCH_FOREST_MOUNTAINS"),
    TALL_BIRCH_HILLS(OLD_GROWTH_BIRCH_FOREST, "MUTATED_BIRCH_FOREST_HILLS", "MESA_PLATEAU_FOREST_MOUNTAINS"),
    THE_END(World.Environment.THE_END, "SKY"),
    THE_VOID("VOID"),
    WARM_OCEAN("WARM_OCEAN"),
    WOODED_BADLANDS_PLATEAU("MESA_ROCK", "MESA_PLATEAU_FOREST"),
    WOODED_HILLS("FOREST_HILLS"),
    WOODED_MOUNTAINS("EXTREME_HILLS_WITH_TREES", "EXTREME_HILLS_PLUS"),
    BAMBOO_JUNGLE(new String[0]),
    BAMBOO_JUNGLE_HILLS(new String[0]),
    DRIPSTONE_CAVES(new String[0]),
    LUSH_CAVES(new String[0]);

    public static final XBiome[] VALUES;
    private static final boolean HORIZONTAL_SUPPORT;
    private static final boolean EXTENDED_MINIMUM;
    @Nullable
    private final Biome biome;
    @Nonnull
    private final World.Environment environment;

    private XBiome(World.Environment environment, String ... legacies) {
        this(environment, (XBiome)null, legacies);
    }

    private XBiome(String ... legacies) {
        this(World.Environment.NORMAL, legacies);
    }

    private XBiome(XBiome newVersion, String ... legacies) {
        this(World.Environment.NORMAL, newVersion, legacies);
    }

    private XBiome(@Nonnull World.Environment environment, XBiome newVersion, String ... legacies) {
        this.environment = environment;
        Data.NAMES.put(this.name(), this);
        for (String legacy : legacies) {
            Data.NAMES.put(legacy, this);
        }
        Biome biome = (Biome)Enums.getIfPresent(Biome.class, (String)this.name()).orNull();
        if (biome == null) {
            if (newVersion != null) {
                biome = newVersion.biome;
            }
            if (biome == null) {
                String legacy;
                String[] stringArray = legacies;
                int n2 = stringArray.length;
                for (int i = 0; i < n2 && (biome = (Biome)Enums.getIfPresent(Biome.class, (String)(legacy = stringArray[i])).orNull()) == null; ++i) {
                }
            }
        }
        this.biome = biome;
    }

    @Nonnull
    private static String format(@Nonnull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    @Nonnull
    public static Optional<XBiome> matchXBiome(@Nonnull String biome) {
        if (biome == null || biome.isEmpty()) {
            throw new IllegalArgumentException("Cannot match XBiome of a null or empty biome name");
        }
        return Optional.ofNullable((XBiome)((Object)Data.NAMES.get(XBiome.format(biome))));
    }

    @Nonnull
    public static XBiome matchXBiome(@Nonnull Biome biome) {
        Objects.requireNonNull(biome, "Cannot match XBiome of a null biome");
        return Objects.requireNonNull((XBiome)((Object)Data.NAMES.get(biome.name())), () -> "Unsupported biome: " + biome.name());
    }

    @Nonnull
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public Biome getBiome() {
        return this.biome;
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Chunk chunk) {
        Objects.requireNonNull(this.biome, () -> "Unsupported biome: " + this.name());
        Objects.requireNonNull(chunk, "Cannot set biome of null chunk");
        if (!chunk.isLoaded() && !chunk.load(true)) {
            throw new IllegalStateException("Could not load chunk at " + chunk.getX() + ", " + chunk.getZ());
        }
        int heightMax = HORIZONTAL_SUPPORT ? chunk.getWorld().getMaxHeight() : 1;
        int heightMin = EXTENDED_MINIMUM ? chunk.getWorld().getMinHeight() : 0;
        return CompletableFuture.runAsync(() -> {
            for (int x = 0; x < 16; ++x) {
                for (int y = heightMin; y < heightMax; y += 4) {
                    for (int z = 0; z < 16; ++z) {
                        Block block = chunk.getBlock(x, y, z);
                        if (block.getBiome() == this.biome) continue;
                        block.setBiome(this.biome);
                    }
                }
            }
        }).exceptionally(result -> {
            result.printStackTrace();
            return null;
        });
    }

    @Nonnull
    public CompletableFuture<Void> setBiome(@Nonnull Location start, @Nonnull Location end) {
        Objects.requireNonNull(start, "Start location cannot be null");
        Objects.requireNonNull(end, "End location cannot be null");
        Objects.requireNonNull(this.biome, () -> "Unsupported biome: " + this.name());
        World world = start.getWorld();
        if (!world.getUID().equals(end.getWorld().getUID())) {
            throw new IllegalArgumentException("Location worlds mismatch");
        }
        int heightMax = HORIZONTAL_SUPPORT ? world.getMaxHeight() : 1;
        int heightMin = EXTENDED_MINIMUM ? world.getMinHeight() : 0;
        return CompletableFuture.runAsync(() -> {
            for (int x = start.getBlockX(); x < end.getBlockX(); ++x) {
                for (int y = heightMin; y < heightMax; y += 4) {
                    for (int z = start.getBlockZ(); z < end.getBlockZ(); ++z) {
                        Block block = new Location(world, (double)x, (double)y, (double)z).getBlock();
                        if (block.getBiome() == this.biome) continue;
                        block.setBiome(this.biome);
                    }
                }
            }
        }).exceptionally(result -> {
            result.printStackTrace();
            return null;
        });
    }

    static {
        VALUES = XBiome.values();
        HORIZONTAL_SUPPORT = XMaterial.supports(16);
        EXTENDED_MINIMUM = XMaterial.supports(17);
    }

    private static final class Data {
        private static final Map<String, XBiome> NAMES = new HashMap<String, XBiome>();

        private Data() {
        }
    }
}

