/*
 * Decompiled with CFR 0.152.
 */
package com.github.bsideup.jabel;

import com.github.bsideup.jabel.RecordsRetrofittingTaskListener;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.JavaModule;

public class JabelCompilerPlugin
implements Plugin {
    @Override
    public void init(JavacTask task, String ... args) {
        Context context = ((BasicJavacTask)task).getContext();
        JavacMessages.instance(context).add(locale -> new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return "{0}";
            }

            @Override
            public Enumeration<String> getKeys() {
                return Collections.enumeration(Arrays.asList("missing.desugar.on.record"));
            }
        });
        task.addTaskListener(new RecordsRetrofittingTaskListener(context));
        System.out.println("Jabel: initialized");
    }

    @Override
    public String getName() {
        return "jabel";
    }

    @Override
    public boolean autoStart() {
        return true;
    }

    static {
        HashMap<String, AsmVisitorWrapper> visitors = new HashMap<String, AsmVisitorWrapper>(){
            {
                AsmVisitorWrapper.ForDeclaredMethods checkSourceLevelAdvice = Advice.to(CheckSourceLevelAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"checkSourceLevel").and((ElementMatcher)ElementMatchers.takesArguments((int)2)));
                FieldAccessStub allowRecordsEraFeaturesAdvice = new FieldAccessStub("allowRecords", true);
                this.put("com.sun.tools.javac.parser.JavacParser", new AsmVisitorWrapper.Compound(new AsmVisitorWrapper[]{checkSourceLevelAdvice, allowRecordsEraFeaturesAdvice}));
                this.put("com.sun.tools.javac.parser.JavaTokenizer", checkSourceLevelAdvice);
                this.put("com.sun.tools.javac.comp.Check", allowRecordsEraFeaturesAdvice);
                this.put("com.sun.tools.javac.comp.Attr", allowRecordsEraFeaturesAdvice);
                this.put("com.sun.tools.javac.comp.Resolve", allowRecordsEraFeaturesAdvice);
                this.put("com.sun.tools.javac.code.Source$Feature", Advice.to(AllowedInSourceAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"allowedInSource").and((ElementMatcher)ElementMatchers.takesArguments((int)1))));
            }
        };
        try {
            ByteBuddyAgent.install();
        }
        catch (Exception e) {
            ByteBuddyAgent.install((ByteBuddyAgent.AttachmentProvider)new ByteBuddyAgent.AttachmentProvider.Compound(new ByteBuddyAgent.AttachmentProvider[]{ByteBuddyAgent.AttachmentProvider.ForJ9Vm.INSTANCE, ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.JVM_ROOT, ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.JDK_ROOT, ByteBuddyAgent.AttachmentProvider.ForStandardToolsJarVm.MACINTOSH, ByteBuddyAgent.AttachmentProvider.ForUserDefinedToolsJar.INSTANCE, ByteBuddyAgent.AttachmentProvider.ForEmulatedAttachment.INSTANCE}));
        }
        ByteBuddy byteBuddy = new ByteBuddy().with((MethodGraph.Compiler)MethodGraph.Compiler.ForDeclaredMethods.INSTANCE);
        ClassLoader classLoader = JavacTask.class.getClassLoader();
        ClassFileLocator classFileLocator = ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader);
        TypePool typePool = TypePool.ClassLoading.of((ClassLoader)classLoader);
        visitors.forEach((className, visitor) -> byteBuddy.decorate(typePool.describe(className).resolve(), classFileLocator).visit(visitor).make().load(classLoader, (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent()));
        final JavaModule jabelModule = JavaModule.ofType(JabelCompilerPlugin.class);
        ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)ByteBuddyAgent.getInstrumentation(), (JavaModule)JavaModule.ofType(JavacTask.class), Collections.emptySet(), Collections.emptyMap(), (Map)new HashMap<String, Set<JavaModule>>(){
            {
                this.put("com.sun.tools.javac.api", Collections.singleton(jabelModule));
                this.put("com.sun.tools.javac.tree", Collections.singleton(jabelModule));
                this.put("com.sun.tools.javac.code", Collections.singleton(jabelModule));
                this.put("com.sun.tools.javac.util", Collections.singleton(jabelModule));
            }
        }, Collections.emptySet(), Collections.emptyMap());
    }

    private static class FieldAccessStub
    extends AsmVisitorWrapper.AbstractBase {
        final String fieldName;
        final Object value;

        public FieldAccessStub(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return new ClassVisitor(589824, classVisitor){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                    return new MethodVisitor(589824, methodVisitor){

                        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                            if (opcode == 180 && fieldName.equalsIgnoreCase(name)) {
                                super.visitInsn(87);
                                super.visitLdcInsn(value);
                            } else {
                                super.visitFieldInsn(opcode, owner, name, descriptor);
                            }
                        }
                    };
                }
            };
        }
    }

    static class CheckSourceLevelAdvice {
        CheckSourceLevelAdvice() {
        }

        @Advice.OnMethodEnter
        static void checkSourceLevel(@Advice.Argument(value=1, readOnly=false) Source.Feature feature) {
            if (feature.allowedInSource(Source.JDK8)) {
                feature = Source.Feature.LAMBDA;
            }
        }
    }

    static class AllowedInSourceAdvice {
        AllowedInSourceAdvice() {
        }

        @Advice.OnMethodEnter
        static void allowedInSource(@Advice.This Source.Feature feature, @Advice.Argument(value=0, readOnly=false) Source source) {
            switch (feature.name()) {
                case "PRIVATE_SAFE_VARARGS": 
                case "SWITCH_EXPRESSION": 
                case "SWITCH_RULE": 
                case "SWITCH_MULTIPLE_CASE_LABELS": 
                case "LOCAL_VARIABLE_TYPE_INFERENCE": 
                case "VAR_SYNTAX_IMPLICIT_LAMBDAS": 
                case "DIAMOND_WITH_ANONYMOUS_CLASS_CREATION": 
                case "EFFECTIVELY_FINAL_VARIABLES_IN_TRY_WITH_RESOURCES": 
                case "TEXT_BLOCKS": 
                case "PATTERN_MATCHING_IN_INSTANCEOF": 
                case "REIFIABLE_TYPES_INSTANCEOF": 
                case "RECORDS": {
                    source = Source.DEFAULT;
                }
            }
        }
    }
}

