/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.vhs;

import com.github.axet.vget.info.VideoInfo;
import java.net.URI;
import java.net.URL;

public class YouTubeInfo
extends VideoInfo {
    private StreamInfo vq;
    private URI playerURI;

    public YouTubeInfo(URL web) {
        super(web);
    }

    public StreamInfo getVideoQuality() {
        return this.vq;
    }

    public void setStreamInfo(StreamInfo vq) {
        this.vq = vq;
    }

    public URI getPlayerURI() {
        return this.playerURI;
    }

    public void setPlayerURI(URI playerURI) {
        this.playerURI = playerURI;
    }

    public static enum AudioQuality {
        k256,
        k192,
        k160,
        k128,
        k96,
        k70,
        k64,
        k50,
        k48,
        k36,
        k24;

    }

    public static enum Container {
        FLV,
        GP3,
        MP4,
        WEBM;

    }

    public static enum Encoding {
        H263,
        H264,
        VP8,
        VP9,
        MP4,
        MP3,
        AAC,
        VORBIS,
        OPUS;

    }

    public static class StreamAudio
    extends StreamInfo {
        public Encoding audio;
        public AudioQuality aq;

        public StreamAudio() {
        }

        public StreamAudio(Container c, Encoding a, AudioQuality q) {
            super(c);
            this.audio = a;
            this.aq = q;
        }

        @Override
        public String toString() {
            return String.valueOf(this.c.toString()) + " " + this.audio.toString() + " " + this.aq.toString();
        }
    }

    public static class StreamCombined
    extends StreamInfo {
        public Encoding video;
        public YoutubeQuality vq;
        public Encoding audio;
        public AudioQuality aq;

        public StreamCombined() {
        }

        public StreamCombined(Container c, Encoding v, YoutubeQuality vq, Encoding a, AudioQuality aq) {
            super(c);
            this.video = v;
            this.vq = vq;
            this.audio = a;
            this.aq = aq;
        }

        @Override
        public String toString() {
            return String.valueOf(this.c.toString()) + " " + this.video.toString() + "(" + this.vq.toString() + ") " + this.audio.toString() + "(" + this.aq.toString() + ")";
        }
    }

    public static class StreamInfo {
        public Container c;

        public StreamInfo() {
        }

        public StreamInfo(Container c) {
            this.c = c;
        }

        public String toString() {
            return this.c.toString();
        }
    }

    public static class StreamVideo
    extends StreamInfo {
        public Encoding video;
        public YoutubeQuality vq;

        public StreamVideo() {
        }

        public StreamVideo(Container c, Encoding v, YoutubeQuality vq) {
            super(c);
            this.vq = vq;
            this.video = v;
        }

        @Override
        public String toString() {
            return String.valueOf(this.c.toString()) + " " + this.video.toString() + "(" + this.vq.toString() + ")";
        }
    }

    public static enum YoutubeQuality {
        p3072,
        p2304,
        p2160,
        p1440,
        p1080,
        p720,
        p520,
        p480,
        p360,
        p270,
        p240,
        p224,
        p144;

    }
}

