/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.info;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.ex.DownloadError;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class YouTubeParser
extends VGetParser {
    HashMap<VideoInfo.VideoQuality, URL> sNextVideoURL = new HashMap();
    URL source;

    public YouTubeParser(URL input) {
        this.source = input;
    }

    public static boolean probe(URL url) {
        return url.toString().contains("youtube.com");
    }

    void downloadone(VideoInfo info, AtomicBoolean stop, Runnable notify) throws Exception {
        try {
            this.extractEmbedded(info, stop, notify);
        }
        catch (EmbeddingDisabled e) {
            this.streamCpature(info, stop, notify);
        }
    }

    void streamCpature(final VideoInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        String html = WGet.getHtml((URL)info.getWeb(), (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setDelay(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        this.extractHtmlInfo(info, html);
        this.extractIcon(info, html);
    }

    void addVideo(VideoInfo.VideoQuality vd, String s) throws MalformedURLException {
        if (s != null) {
            this.sNextVideoURL.put(vd, new URL(s));
        }
    }

    void addVideo(Integer itag, String url) throws MalformedURLException {
        switch (itag) {
            case 38: {
                this.addVideo(VideoInfo.VideoQuality.p1080, url);
                break;
            }
            case 37: {
                this.addVideo(VideoInfo.VideoQuality.p1080, url);
                break;
            }
            case 46: {
                this.addVideo(VideoInfo.VideoQuality.p1080, url);
                break;
            }
            case 22: {
                this.addVideo(VideoInfo.VideoQuality.p720, url);
                break;
            }
            case 45: {
                this.addVideo(VideoInfo.VideoQuality.p720, url);
                break;
            }
            case 35: {
                this.addVideo(VideoInfo.VideoQuality.p480, url);
                break;
            }
            case 44: {
                this.addVideo(VideoInfo.VideoQuality.p480, url);
                break;
            }
            case 18: {
                this.addVideo(VideoInfo.VideoQuality.p360, url);
                break;
            }
            case 34: {
                this.addVideo(VideoInfo.VideoQuality.p360, url);
                break;
            }
            case 43: {
                this.addVideo(VideoInfo.VideoQuality.p360, url);
                break;
            }
            case 6: {
                this.addVideo(VideoInfo.VideoQuality.p270, url);
                break;
            }
            case 5: {
                this.addVideo(VideoInfo.VideoQuality.p224, url);
            }
        }
    }

    public static String extractId(URL url) {
        Pattern u = Pattern.compile("youtube.com/watch?.*v=([^&]*)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("youtube.com/v/([^&]*)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return null;
    }

    void extractEmbedded(final VideoInfo info, AtomicBoolean stop, final Runnable notify) throws Exception {
        String id = YouTubeParser.extractId(this.source);
        if (id == null) {
            throw new RuntimeException("unknown url");
        }
        info.setTitle(String.format("http://www.youtube.com/watch?v=%s", id));
        String get = String.format("http://www.youtube.com/get_video_info?video_id=%s&el=embedded&ps=default&eurl=", id);
        URL url = new URL(get);
        String qs = WGet.getHtml((URL)url, (WGet.HtmlLoader)new WGet.HtmlLoader(){

            public void notifyRetry(int delay, Throwable e) {
                info.setDelay(delay, e);
                notify.run();
            }

            public void notifyDownloading() {
                info.setState(VideoInfo.States.DOWNLOADING);
                notify.run();
            }

            public void notifyMoved() {
                info.setState(VideoInfo.States.RETRYING);
                notify.run();
            }
        }, (AtomicBoolean)stop);
        Map<String, String> map = YouTubeParser.getQueryMap(qs);
        if (map.get("status").equals("fail")) {
            String r = URLDecoder.decode(map.get("reason"), "UTF-8");
            if (map.get("errorcode").equals("150")) {
                throw new EmbeddingDisabled("error code 150");
            }
            if (map.get("errorcode").equals("100")) {
                throw new VideoDeleted("error code 100");
            }
            throw new DownloadError(r);
        }
        info.setTitle(URLDecoder.decode(map.get("title"), "UTF-8"));
        String url_encoded_fmt_stream_map = URLDecoder.decode(map.get("url_encoded_fmt_stream_map"), "UTF-8");
        this.extractUrlEncodedVideos(url_encoded_fmt_stream_map);
        String icon = map.get("thumbnail_url");
        icon = URLDecoder.decode(icon, "UTF-8");
        info.setIcon(new URL(icon));
    }

    void extractIcon(VideoInfo info, String html) {
        try {
            Pattern title = Pattern.compile("itemprop=\"thumbnailUrl\" href=\"(.*)\"");
            Matcher titleMatch = title.matcher(html);
            if (titleMatch.find()) {
                String sline = titleMatch.group(1);
                sline = StringEscapeUtils.unescapeHtml4((String)sline);
                info.setIcon(new URL(sline));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getQueryMap(String qs) {
        try {
            qs = qs.trim();
            List list = URLEncodedUtils.parse((URI)new URI(null, null, null, 0, null, qs, null), (String)"UTF-8");
            HashMap<String, String> map = new HashMap<String, String>();
            for (NameValuePair p : list) {
                map.put(p.getName(), p.getValue());
            }
            return map;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(qs, e);
        }
    }

    void extractHtmlInfo(VideoInfo info, String html) throws Exception {
        Pattern title;
        Matcher titleMatch;
        Pattern age = Pattern.compile("(verify_age)");
        Matcher ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new AgeException();
        }
        age = Pattern.compile("(unavailable-player)");
        ageMatch = age.matcher(html);
        if (ageMatch.find()) {
            throw new VideoUnavailablePlayer();
        }
        Pattern urlencod = Pattern.compile("\"url_encoded_fmt_stream_map\": \"([^\"]*)\"");
        Matcher urlencodMatch = urlencod.matcher(html);
        if (urlencodMatch.find()) {
            Pattern encodStream;
            Matcher encodStreamMatch;
            String url_encoded_fmt_stream_map = urlencodMatch.group(1);
            Pattern encod = Pattern.compile("url=(.*)");
            Matcher encodMatch = encod.matcher(url_encoded_fmt_stream_map);
            if (encodMatch.find()) {
                String sline = encodMatch.group(1);
                this.extractUrlEncodedVideos(sline);
            }
            if ((encodStreamMatch = (encodStream = Pattern.compile("stream=(.*)")).matcher(url_encoded_fmt_stream_map)).find()) {
                String[] urlStrings;
                String sline = encodStreamMatch.group(1);
                String[] stringArray = urlStrings = sline.split("stream=");
                int n = urlStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String urlString = stringArray[n2];
                    urlString = StringEscapeUtils.unescapeJava((String)urlString);
                    Pattern link = Pattern.compile("(sparams.*)&itag=(\\d+)&.*&conn=rtmpe(.*),");
                    Matcher linkMatch = link.matcher(urlString);
                    if (linkMatch.find()) {
                        String sparams = linkMatch.group(1);
                        String itag = linkMatch.group(2);
                        String url = linkMatch.group(3);
                        url = "http" + url + "?" + sparams;
                        url = URLDecoder.decode(url, "UTF-8");
                        this.addVideo(Integer.decode(itag), url);
                    }
                    ++n2;
                }
            }
        }
        if ((titleMatch = (title = Pattern.compile("<meta name=\"title\" content=(.*)")).matcher(html)).find()) {
            String sline = titleMatch.group(1);
            String name = sline.replaceFirst("<meta name=\"title\" content=", "").trim();
            name = StringUtils.strip((String)name, (String)"\">");
            name = StringEscapeUtils.unescapeHtml4((String)name);
            info.setTitle(name);
        }
    }

    void extractUrlEncodedVideos(String sline) throws Exception {
        String[] urlStrings;
        String[] stringArray = urlStrings = sline.split("url=");
        int n = urlStrings.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                String url;
                Pattern link;
                Matcher linkMatch;
                String urlString;
                block11: {
                    urlString = stringArray[n2];
                    urlString = StringEscapeUtils.unescapeJava((String)urlString);
                    String url2 = null;
                    Pattern link2 = Pattern.compile("([^&]*)&");
                    Matcher linkMatch2 = link2.matcher(urlString);
                    if (linkMatch2.find()) {
                        url2 = linkMatch2.group(1);
                        url2 = URLDecoder.decode(url2, "UTF-8");
                    }
                    String itag = null;
                    Pattern link3 = Pattern.compile("itag=(\\d+)");
                    Matcher linkMatch3 = link3.matcher(urlString);
                    if (linkMatch3.find()) {
                        itag = linkMatch3.group(1);
                    }
                    String sig = null;
                    Pattern link42 = Pattern.compile("sig=([^&]*)&");
                    Matcher linkMatch4 = link42.matcher(urlString);
                    if (linkMatch4.find()) {
                        sig = linkMatch4.group(1);
                    }
                    if (url2 != null) {
                        try {
                            new URL(url2);
                            if (sig != null) {
                                url2 = String.valueOf(url2) + "&signature=" + sig;
                            }
                            if (itag == null) break block11;
                            this.addVideo(Integer.decode(itag), url2);
                            break block12;
                        }
                        catch (MalformedURLException link42) {
                            // empty catch block
                        }
                    }
                }
                if ((linkMatch = (link = Pattern.compile("(.*)&type=(.*)&fallback_host=(.*)&sig=(.*)&quality=(.*),itag=(\\d+)")).matcher(urlString)).find()) {
                    url = linkMatch.group(1);
                    String sig = linkMatch.group(4);
                    String itag = linkMatch.group(6);
                    url = URLDecoder.decode(url, "UTF-8");
                    url = String.valueOf(url) + "&signature=" + sig;
                    this.addVideo(Integer.decode(itag), url);
                } else {
                    link = Pattern.compile("(.*)&quality=(.*)&fallback_host=(.*)&type=(.*)itag=(\\d+)");
                    linkMatch = link.matcher(urlString);
                    if (linkMatch.find()) {
                        url = linkMatch.group(1);
                        String itag = linkMatch.group(5);
                        url = URLDecoder.decode(url, "UTF-8");
                        this.addVideo(Integer.decode(itag), url);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void extract(VideoInfo info, VideoInfo.VideoQuality max, AtomicBoolean stop, Runnable notify) {
        try {
            this.downloadone(info, stop, notify);
            this.getVideo(info, this.sNextVideoURL, max);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class AgeException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public AgeException() {
            super("Age restriction, account required");
        }
    }

    public static class EmbeddingDisabled
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public EmbeddingDisabled(String msg) {
            super(msg);
        }
    }

    public static class PrivateVideoException
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public PrivateVideoException() {
            super("Private video");
        }

        public PrivateVideoException(String s) {
            super(s);
        }
    }

    public static class VideoDeleted
    extends DownloadError {
        private static final long serialVersionUID = 1L;

        public VideoDeleted(String msg) {
            super(msg);
        }
    }

    public static class VideoUnavailablePlayer
    extends DownloadError {
        private static final long serialVersionUID = 10905065542230199L;

        public VideoUnavailablePlayer() {
            super("unavailable-player");
        }
    }
}

