/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.info;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VideoInfo;
import com.github.axet.wget.WGet;
import com.github.axet.wget.info.ex.DownloadError;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class VimeoParser
extends VGetParser {
    HashMap<VideoInfo.VideoQuality, URL> sNextVideoURL = new HashMap();
    URL source;

    public VimeoParser(URL input) {
        this.source = input;
    }

    public static boolean probe(URL url) {
        return url.toString().contains("vimeo.com");
    }

    public static String extractId(URL url) {
        Pattern u = Pattern.compile("vimeo.com.*/(\\d+)");
        Matcher um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        u = Pattern.compile("vimeo.com.*=(\\d+)");
        um = u.matcher(url.toString());
        if (um.find()) {
            return um.group(1);
        }
        return null;
    }

    void downloadone(final VideoInfo info, AtomicBoolean stop, final Runnable notify) {
        try {
            String[] ll;
            String id = VimeoParser.extractId(info.getWeb());
            if (id == null) {
                throw new DownloadError("unknown url");
            }
            String clip = "http://vimeo.com/" + id;
            URL url = new URL(clip);
            String html = WGet.getHtml((URL)url, (WGet.HtmlLoader)new WGet.HtmlLoader(){

                public void notifyRetry(int delay, Throwable e) {
                    info.setDelay(delay, e);
                    notify.run();
                }

                public void notifyDownloading() {
                    info.setState(VideoInfo.States.EXTRACTING);
                    notify.run();
                }

                public void notifyMoved() {
                    info.setState(VideoInfo.States.RETRYING);
                    notify.run();
                }
            }, (AtomicBoolean)stop);
            Pattern u = Pattern.compile("\"signature\":\"([0-9a-f]+)\"");
            Matcher um = u.matcher(html);
            if (!um.find()) {
                throw new DownloadError("unknown signature vimeo respond");
            }
            String sig = um.group(1);
            Pattern u2 = Pattern.compile("\"timestamp\":(\\d+)");
            Matcher um2 = u2.matcher(html);
            if (!um2.find()) {
                throw new DownloadError("unknown timestamp vimeo respond");
            }
            String exp = um2.group(1);
            TreeSet<String> qualities = new TreeSet<String>();
            Pattern u3 = Pattern.compile("\"qualities\":\\[([^\\]]*\")\\]");
            Matcher um3 = u3.matcher(html);
            if (!um3.find()) {
                throw new DownloadError("unknown qualities vimeo respond");
            }
            String list = um3.group(1);
            String[] stringArray = ll = list.split(",");
            int n = ll.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                qualities.add(s.replaceAll("\"", ""));
                ++n2;
            }
            Pattern u4 = Pattern.compile("\"thumbnail\":\"([^\"]*)\"");
            Matcher um4 = u4.matcher(html);
            if (!um4.find()) {
                throw new DownloadError("unknown timestamp vimeo respond");
            }
            String icon = um4.group(1);
            icon = StringEscapeUtils.unescapeJava((String)icon);
            u4 = Pattern.compile("\"title\":\"([^\"]+)\"");
            um4 = u4.matcher(html);
            if (!um4.find()) {
                throw new DownloadError("unknown title vimeo respond");
            }
            String sTitle = um4.group(1);
            sTitle = StringEscapeUtils.unescapeHtml4((String)sTitle);
            sTitle = StringEscapeUtils.unescapeJava((String)sTitle);
            info.setTitle(sTitle);
            String get = "http://player.vimeo.com/play_redirect?clip_id=%s&sig=%s&time=%s&quality=%s&codecs=H264,VP8,VP6&type=moogaloop_local&embed_location=&seek=0";
            String hd = String.format(get, id, sig, exp, "hd");
            String sd = String.format(get, id, sig, exp, "sd");
            if (qualities.contains("hd")) {
                this.sNextVideoURL.put(VideoInfo.VideoQuality.p1080, new URL(hd));
            }
            if (qualities.contains("sd")) {
                this.sNextVideoURL.put(VideoInfo.VideoQuality.p480, new URL(sd));
            }
            info.setIcon(new URL(icon));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void extract(VideoInfo info, VideoInfo.VideoQuality max, AtomicBoolean stop, Runnable notify) {
        this.downloadone(info, stop, notify);
        this.getVideo(info, this.sNextVideoURL, max);
    }
}

