/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget.info;

import com.github.axet.vget.info.VGetParser;
import com.github.axet.vget.info.VimeoParser;
import com.github.axet.vget.info.YouTubeParser;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoInfo {
    private VideoQuality vq;
    private DownloadInfo info;
    private String title;
    private URL web;
    private URL icon;
    private States state;
    private Throwable exception;
    private int delay;

    public VideoInfo(URL web) {
        this.setWeb(web);
        this.setState(States.QUEUE);
    }

    public boolean empty() {
        return this.info == null;
    }

    public void reset() {
        this.info = null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DownloadInfo getInfo() {
        return this.info;
    }

    public void setInfo(DownloadInfo info) {
        this.info = info;
    }

    public VideoQuality getVq() {
        return this.vq;
    }

    public void setVq(VideoQuality vq) {
        this.vq = vq;
    }

    public URL getWeb() {
        return this.web;
    }

    public void setWeb(URL source) {
        this.web = source;
    }

    public void extract(AtomicBoolean stop, Runnable notify) {
        VGetParser ei = null;
        if (YouTubeParser.probe(this.web)) {
            ei = new YouTubeParser(this.web);
        }
        if (VimeoParser.probe(this.web)) {
            ei = new VimeoParser(this.web);
        }
        if (ei == null) {
            throw new RuntimeException("unsupported web site");
        }
        try {
            ei.extract(this, stop, notify);
            this.info.extract(stop, notify);
        }
        catch (DownloadInterruptedError e) {
            this.setState(States.STOP, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.setState(States.ERROR, e);
            throw e;
        }
    }

    public States getState() {
        return this.state;
    }

    public void setState(States state) {
        this.state = state;
        this.exception = null;
        this.delay = 0;
    }

    public void setState(States state, Throwable e) {
        this.state = state;
        this.exception = e;
        this.delay = 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay, Throwable e) {
        this.delay = delay;
        this.exception = e;
        this.state = States.RETRYING;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public URL getIcon() {
        return this.icon;
    }

    public void setIcon(URL icon) {
        this.icon = icon;
    }

    public static enum States {
        QUEUE,
        EXTRACTING,
        EXTRACTING_DONE,
        DOWNLOADING,
        RETRYING,
        DONE,
        ERROR,
        STOP;

    }

    public static enum VideoQuality {
        p2304,
        p1080,
        p720,
        p480,
        p360,
        p270,
        p224;

    }
}

