/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.vget;

import com.github.axet.vget.info.VideoInfo;
import com.github.axet.wget.DirectMultipart;
import com.github.axet.wget.DirectRange;
import com.github.axet.wget.DirectSingle;
import com.github.axet.wget.info.DownloadInfo;
import com.github.axet.wget.info.ex.DownloadError;
import com.github.axet.wget.info.ex.DownloadIOCodeError;
import com.github.axet.wget.info.ex.DownloadIOError;
import com.github.axet.wget.info.ex.DownloadInterruptedError;
import com.github.axet.wget.info.ex.DownloadMultipartError;
import com.github.axet.wget.info.ex.DownloadRetry;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class VGet {
    VideoInfo info;
    File targetDir;
    File targetForce = null;
    File targetFile = null;

    public VGet(URL source, File targetDir) {
        VideoInfo info = new VideoInfo(source);
        this.create(info, targetDir);
    }

    public VGet(VideoInfo info, File targetDir) {
        this.create(info, targetDir);
    }

    void create(VideoInfo video, File targetDir) {
        this.info = video;
        this.targetDir = targetDir;
    }

    public void setTarget(File file) {
        this.targetForce = file;
    }

    public File getTarget() {
        return this.targetFile;
    }

    public VideoInfo getVideo() {
        return this.info;
    }

    public void download() {
        this.download(new AtomicBoolean(false), new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    static String replaceBadChars(String f) {
        String ff;
        String replace = " ";
        f = f.replaceAll("/", replace);
        f = f.replaceAll("\\\\", replace);
        f = f.replaceAll(":", replace);
        f = f.replaceAll("\\?", replace);
        f = f.replaceAll("\\\"", replace);
        f = f.replaceAll("\\*", replace);
        f = f.replaceAll("<", replace);
        f = f.replaceAll(">", replace);
        f = f.replaceAll("\\|", replace);
        f = f.trim();
        f = StringUtils.removeEnd((String)f, (String)".");
        f = f.trim();
        while (!(ff = f.replaceAll("  ", " ")).equals(f)) {
            f = ff;
        }
        return f;
    }

    static String maxFileLength(String str) {
        int max = 50;
        if (str.length() > max) {
            str = str.substring(0, max);
        }
        return str;
    }

    boolean done(AtomicBoolean stop) {
        if (stop.get()) {
            throw new DownloadInterruptedError("stop");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DownloadInterruptedError("interrupted");
        }
        return false;
    }

    void retry(AtomicBoolean stop, Runnable notify, Throwable e) {
        boolean retracted = false;
        while (!retracted) {
            int i = 10;
            while (i >= 0) {
                if (stop.get()) {
                    throw new DownloadInterruptedError("stop");
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new DownloadInterruptedError("interrupted");
                }
                this.info.setDelay(i, e);
                notify.run();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ee) {
                    throw new DownloadInterruptedError((Throwable)ee);
                }
                --i;
            }
            try {
                DownloadInfo infoOld = this.info.getInfo();
                this.info.extract(stop, notify);
                DownloadInfo infoNew = this.info.getInfo();
                if (infoOld.resume(infoNew)) {
                    infoNew.copy(infoOld);
                } else if (this.targetFile != null) {
                    FileUtils.deleteQuietly((File)this.targetFile);
                    this.targetFile = null;
                }
                retracted = true;
            }
            catch (DownloadIOCodeError ee) {
                if (this.retry(ee)) {
                    this.info.setState(VideoInfo.States.RETRYING, ee);
                    notify.run();
                    continue;
                }
                throw ee;
            }
            catch (DownloadRetry ee) {
                this.info.setState(VideoInfo.States.RETRYING, ee);
                notify.run();
            }
        }
    }

    void target(DownloadInfo dinfo) {
        if (this.targetForce != null) {
            this.targetFile = this.targetForce;
            if (dinfo.multipart()) {
                if (!DirectMultipart.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                    this.targetFile = null;
                }
            } else if (dinfo.getRange()) {
                if (!DirectRange.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                    this.targetFile = null;
                }
            } else if (!DirectSingle.canResume((DownloadInfo)dinfo, (File)this.targetFile)) {
                this.targetFile = null;
            }
        }
        if (this.targetFile == null) {
            File f;
            Integer idupcount = 0;
            String sfilename = VGet.replaceBadChars(this.info.getTitle());
            sfilename = VGet.maxFileLength(sfilename);
            String ct = dinfo.getContentType();
            if (ct == null) {
                throw new DownloadRetry("null content type");
            }
            String ext = ct.replaceFirst("video/", "").replaceAll("x-", "");
            do {
                String add = idupcount > 0 ? " (".concat(idupcount.toString()).concat(")") : "";
                f = new File(this.targetDir, String.valueOf(sfilename) + add + "." + ext);
                idupcount = idupcount + 1;
            } while (f.exists());
            this.targetFile = f;
            dinfo.reset();
        }
    }

    boolean retry(Throwable e) {
        if (e == null) {
            return true;
        }
        if (e instanceof DownloadIOCodeError) {
            DownloadIOCodeError c = (DownloadIOCodeError)e;
            switch (c.getCode()) {
                case 403: 
                case 416: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean empty() {
        return this.getVideo().empty();
    }

    public void extract(AtomicBoolean stop, Runnable notify) {
        while (!this.done(stop)) {
            try {
                if (this.info.empty()) {
                    this.info.extract(stop, notify);
                    this.info.setState(VideoInfo.States.EXTRACTING_DONE);
                    notify.run();
                }
                return;
            }
            catch (DownloadRetry e) {
                this.retry(stop, notify, e);
            }
            catch (DownloadMultipartError e) {
                this.checkFileNotFound(e);
                this.checkRetry(e);
                this.retry(stop, notify, e);
            }
            catch (DownloadIOCodeError e) {
                if (this.retry(e)) {
                    this.retry(stop, notify, e);
                    continue;
                }
                throw e;
            }
            catch (DownloadIOError e) {
                this.retry(stop, notify, e);
            }
        }
    }

    void checkRetry(DownloadMultipartError e) {
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (this.retry(ee.getException())) continue;
            throw e;
        }
    }

    void checkFileNotFound(DownloadMultipartError e) {
        FileNotFoundException f = null;
        for (DownloadInfo.Part ee : e.getInfo().getParts()) {
            if (ee.getException() == null) continue;
            if (ee.getException().getCause() == null) {
                return;
            }
            if (!(ee.getException().getCause() instanceof FileNotFoundException)) break;
            if (f == null) {
                f = (FileNotFoundException)ee.getException().getCause();
                continue;
            }
            FileNotFoundException ff = (FileNotFoundException)ee.getException().getCause();
            if (ff.getMessage().equals(f.getMessage())) continue;
            return;
        }
        if (f != null) {
            throw new DownloadError(f);
        }
    }

    public void download(AtomicBoolean stop, final Runnable notify) {
        try {
            if (this.empty()) {
                this.extract(stop, notify);
            }
            while (!this.done(stop)) {
                try {
                    DirectMultipart direct;
                    final DownloadInfo dinfo = this.info.getInfo();
                    if (dinfo.getContentType() == null || !dinfo.getContentType().contains("video/")) {
                        throw new DownloadRetry("unable to download video, bad content");
                    }
                    this.target(dinfo);
                    if (dinfo.multipart()) {
                        direct = new DirectMultipart(dinfo, this.targetFile);
                    } else if (dinfo.getRange()) {
                        if (this.targetFile.exists() && this.targetFile.length() != dinfo.getCount()) {
                            this.targetFile = null;
                        }
                        direct = new DirectRange(dinfo, this.targetFile);
                    } else {
                        direct = new DirectSingle(dinfo, this.targetFile);
                    }
                    direct.download(stop, new Runnable(){

                        @Override
                        public void run() {
                            switch (dinfo.getState()) {
                                case DOWNLOADING: {
                                    VGet.this.info.setState(VideoInfo.States.DOWNLOADING);
                                    notify.run();
                                    break;
                                }
                                case RETRYING: {
                                    VGet.this.info.setDelay(dinfo.getDelay(), dinfo.getException());
                                    notify.run();
                                }
                            }
                        }
                    });
                    this.info.setState(VideoInfo.States.DONE);
                    notify.run();
                    return;
                }
                catch (DownloadRetry e) {
                    this.retry(stop, notify, e);
                }
                catch (DownloadMultipartError e) {
                    this.checkFileNotFound(e);
                    this.checkRetry(e);
                    this.retry(stop, notify, e);
                }
                catch (DownloadIOCodeError e) {
                    if (this.retry(e)) {
                        this.retry(stop, notify, e);
                        continue;
                    }
                    throw e;
                }
                catch (DownloadIOError e) {
                    this.retry(stop, notify, e);
                }
            }
        }
        catch (DownloadInterruptedError e) {
            this.info.setState(VideoInfo.States.STOP, e);
            notify.run();
            throw e;
        }
        catch (RuntimeException e) {
            this.info.setState(VideoInfo.States.ERROR, e);
            notify.run();
            throw e;
        }
    }
}

