/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexdlaird.ngrok.protocol;

import com.github.alexdlaird.ngrok.installer.NgrokVersion;
import com.github.alexdlaird.ngrok.protocol.BindTls;
import com.github.alexdlaird.ngrok.protocol.Proto;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class CreateTunnel {
    private final transient NgrokVersion ngrokVersion;
    private final String name;
    private final Proto proto;
    private final String addr;
    private final Boolean inspect;
    private final String auth;
    private final String hostHeader;
    private final BindTls bindTls;
    private final String subdomain;
    private final String hostname;
    private final String crt;
    private final String key;
    private final String clientCas;
    private final String remoteAddr;
    private final String metadata;
    private final List<String> schemes;
    private final List<String> basicAuth;

    private CreateTunnel(Builder builder) {
        this.ngrokVersion = builder.ngrokVersion;
        this.name = builder.name;
        this.proto = builder.proto;
        this.addr = builder.addr;
        this.inspect = builder.inspect;
        this.auth = builder.auth;
        this.hostHeader = builder.hostHeader;
        this.bindTls = builder.bindTls;
        this.subdomain = builder.subdomain;
        this.hostname = builder.hostname;
        this.crt = builder.crt;
        this.key = builder.key;
        this.clientCas = builder.clientCas;
        this.remoteAddr = builder.remoteAddr;
        this.metadata = builder.metadata;
        this.schemes = builder.schemes;
        this.basicAuth = builder.basicAuth;
    }

    public NgrokVersion getNgrokVersion() {
        return this.ngrokVersion;
    }

    public String getName() {
        return this.name;
    }

    public Proto getProto() {
        return this.proto;
    }

    public String getAddr() {
        return this.addr;
    }

    public Boolean isInspect() {
        return this.inspect;
    }

    public String getAuth() {
        return this.auth;
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public BindTls getBindTls() {
        return this.bindTls;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCrt() {
        return this.crt;
    }

    public String getKey() {
        return this.key;
    }

    public String getClientCas() {
        return this.clientCas;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public static class Builder {
        private boolean setDefaults = false;
        private NgrokVersion ngrokVersion;
        private String name;
        private Proto proto;
        private String addr;
        private Boolean inspect;
        private BindTls bindTls;
        private String auth;
        private String hostHeader;
        private String subdomain;
        private String hostname;
        private String crt;
        private String key;
        private String clientCas;
        private String remoteAddr;
        private String metadata;
        private List<String> schemes;
        private List<String> basicAuth;

        public Builder() {
        }

        public Builder(boolean setDefaults) {
            this.setDefaults = setDefaults;
        }

        public Builder(CreateTunnel createTunnel) {
            this.setDefaults = true;
            this.ngrokVersion = createTunnel.ngrokVersion;
            this.name = createTunnel.name;
            this.proto = createTunnel.proto;
            this.addr = createTunnel.addr;
            this.inspect = createTunnel.inspect;
            this.bindTls = createTunnel.bindTls;
            this.auth = createTunnel.auth;
            this.hostHeader = createTunnel.hostHeader;
            this.subdomain = createTunnel.subdomain;
            this.hostname = createTunnel.hostname;
            this.crt = createTunnel.crt;
            this.key = createTunnel.key;
            this.clientCas = createTunnel.clientCas;
            this.remoteAddr = createTunnel.remoteAddr;
            this.metadata = createTunnel.metadata;
            this.schemes = createTunnel.schemes;
            this.basicAuth = createTunnel.basicAuth;
        }

        public Builder withNgrokVersion(NgrokVersion ngrokVersion) {
            this.ngrokVersion = ngrokVersion;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withProto(Proto proto) {
            this.proto = proto;
            return this;
        }

        public Builder withAddr(String addr) {
            this.addr = addr;
            return this;
        }

        public Builder withAddr(int addr) {
            return this.withAddr(String.valueOf(addr));
        }

        public Builder withoutInspect() {
            this.inspect = false;
            return this;
        }

        public Builder withAuth(String auth) {
            if (Objects.nonNull(this.basicAuth)) {
                throw new IllegalArgumentException("Cannot set both 'auth' and 'basicAuth'.");
            }
            this.auth = auth;
            return this;
        }

        public Builder withHostHeader(String hostHeader) {
            this.hostHeader = hostHeader;
            return this;
        }

        public Builder withBindTls(BindTls bindTls) {
            if (Objects.nonNull(this.schemes)) {
                throw new IllegalArgumentException("Cannot set both 'schemes' and 'bindTls'.");
            }
            this.bindTls = bindTls;
            return this;
        }

        public Builder withBindTls(boolean bindTls) {
            return this.withBindTls(BindTls.valueOf(String.valueOf(bindTls).toUpperCase()));
        }

        public Builder withSubdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder withCrt(String crt) {
            this.crt = crt;
            return this;
        }

        public Builder withKey(String key) {
            this.key = key;
            return this;
        }

        public Builder withClientCas(String clientCas) {
            this.clientCas = clientCas;
            return this;
        }

        public Builder withRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder withMetadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withSchemes(List<String> schemes) {
            if (Objects.nonNull((Object)this.bindTls)) {
                throw new IllegalArgumentException("Cannot set both 'schemes' and 'bindTls'.");
            }
            this.schemes = schemes;
            return this;
        }

        public Builder withBasicAuth(List<String> basicAuth) {
            if (Objects.nonNull(this.auth)) {
                throw new IllegalArgumentException("Cannot set both 'auth' and 'basicAuth'.");
            }
            this.basicAuth = basicAuth;
            return this;
        }

        public void withTunnelDefinition(Map<String, Object> tunnelDefinition) {
            if (Objects.isNull((Object)this.proto) && tunnelDefinition.containsKey("proto")) {
                this.proto = Proto.valueOf(((String)tunnelDefinition.get("proto")).toUpperCase());
            }
            if (Objects.isNull(this.addr) && tunnelDefinition.containsKey("addr")) {
                this.addr = (String)tunnelDefinition.get("addr");
            }
            if (Objects.isNull(this.inspect) && tunnelDefinition.containsKey("inspect")) {
                this.inspect = Boolean.valueOf(String.valueOf(tunnelDefinition.get("inspect")));
            }
            if (Objects.isNull((Object)this.bindTls) && tunnelDefinition.containsKey("bind_tls")) {
                this.bindTls = BindTls.valueOf(String.valueOf(tunnelDefinition.get("bind_tls")).toUpperCase());
            }
            if (Objects.isNull(this.auth) && tunnelDefinition.containsKey("auth")) {
                this.auth = (String)tunnelDefinition.get("auth");
            }
            if (Objects.isNull(this.hostHeader) && tunnelDefinition.containsKey("host_header")) {
                this.hostHeader = (String)tunnelDefinition.get("host_header");
            }
            if (Objects.isNull(this.subdomain) && tunnelDefinition.containsKey("subdomain")) {
                this.subdomain = (String)tunnelDefinition.get("subdomain");
            }
            if (Objects.isNull(this.hostname) && tunnelDefinition.containsKey("hostname")) {
                this.hostname = (String)tunnelDefinition.get("hostname");
            }
            if (Objects.isNull(this.crt) && tunnelDefinition.containsKey("crt")) {
                this.crt = (String)tunnelDefinition.get("crt");
            }
            if (Objects.isNull(this.key) && tunnelDefinition.containsKey("key")) {
                this.key = (String)tunnelDefinition.get("key");
            }
            if (Objects.isNull(this.clientCas) && tunnelDefinition.containsKey("client_cas")) {
                this.clientCas = (String)tunnelDefinition.get("client_cas");
            }
            if (Objects.isNull(this.remoteAddr) && tunnelDefinition.containsKey("remote_addr")) {
                this.remoteAddr = (String)tunnelDefinition.get("remote_addr");
            }
            if (Objects.isNull(this.metadata) && tunnelDefinition.containsKey("metadata")) {
                this.metadata = (String)tunnelDefinition.get("metadata");
            }
            if (Objects.isNull(this.schemes) && tunnelDefinition.containsKey("schemes")) {
                this.schemes = (List)tunnelDefinition.get("schemes");
            }
            if (Objects.isNull(this.schemes) && tunnelDefinition.containsKey("schemes")) {
                this.basicAuth = (List)tunnelDefinition.get("basic_auth");
            }
        }

        public CreateTunnel build() {
            if (Objects.isNull((Object)this.ngrokVersion)) {
                this.ngrokVersion = NgrokVersion.V3;
            }
            if (this.setDefaults) {
                if (Objects.isNull((Object)this.proto)) {
                    this.proto = Proto.HTTP;
                }
                if (Objects.isNull(this.addr)) {
                    this.addr = "80";
                }
                if (Objects.isNull(this.name)) {
                    this.name = !this.addr.startsWith("file://") ? String.format("%s-%s-%s", new Object[]{this.proto, this.addr, UUID.randomUUID()}) : String.format("%s-file-%s", new Object[]{this.proto, UUID.randomUUID()});
                }
                if (this.ngrokVersion == NgrokVersion.V2 && Objects.isNull((Object)this.bindTls)) {
                    this.bindTls = BindTls.BOTH;
                }
                if (this.ngrokVersion == NgrokVersion.V3) {
                    if (Objects.nonNull((Object)this.bindTls)) {
                        this.schemes = this.bindTls == BindTls.TRUE ? List.of("https") : (this.bindTls == BindTls.FALSE ? List.of("http") : List.of("http", "https"));
                        this.bindTls = null;
                    }
                    if (Objects.nonNull(this.auth)) {
                        this.basicAuth = List.of(this.auth);
                        this.auth = null;
                    }
                }
            }
            return new CreateTunnel(this);
        }
    }
}

