/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexdlaird.ngrok.process;

import com.github.alexdlaird.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class NgrokLog
extends HashMap<String, String> {
    private final String line;
    private String t;
    private String lvl = Level.INFO.getName();
    private String msg;
    private String err;
    private String addr;

    public NgrokLog(String line) {
        this.line = line.strip();
        for (String i : this.shellSplit(this.line)) {
            String[] split = i.split("=", 2);
            String key = split[0];
            String value = "";
            if (split.length > 1) {
                value = split[1];
            }
            if (key.equals("lvl")) {
                if (StringUtils.isBlank(value)) {
                    value = this.lvl;
                }
                switch (value = value.toUpperCase()) {
                    case "CRIT": 
                    case "ERR": 
                    case "EROR": {
                        value = Level.SEVERE.getName();
                        break;
                    }
                    case "WARN": {
                        value = Level.WARNING.getName();
                    }
                }
            }
            switch (key) {
                case "t": {
                    this.t = value;
                    break;
                }
                case "lvl": {
                    this.lvl = value;
                    break;
                }
                case "msg": {
                    this.msg = value;
                    break;
                }
                case "err": {
                    this.err = value;
                    break;
                }
                case "addr": {
                    this.addr = value;
                }
            }
            this.put(key, value);
        }
    }

    public String getLine() {
        return this.line;
    }

    public String getT() {
        return this.t;
    }

    public String getLvl() {
        return this.lvl;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErr() {
        return this.err;
    }

    public String getAddr() {
        return this.addr;
    }

    private List<String> shellSplit(CharSequence line) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean escaping = false;
        char quoteChar = ' ';
        boolean quoting = false;
        int lastCloseQuoteIndex = Integer.MIN_VALUE;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (escaping) {
                current.append(c);
                escaping = false;
                continue;
            }
            if (!(c != '\\' || quoting && quoteChar == '\'')) {
                escaping = true;
                continue;
            }
            if (quoting && c == quoteChar) {
                quoting = false;
                lastCloseQuoteIndex = i;
                continue;
            }
            if (!(quoting || c != '\'' && c != '\"')) {
                quoting = true;
                quoteChar = c;
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                if (current.length() <= 0 && lastCloseQuoteIndex != i - 1) continue;
                tokens.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0 || lastCloseQuoteIndex == line.length() - 1) {
            tokens.add(current.toString());
        }
        return Collections.unmodifiableList(tokens);
    }
}

