/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexdlaird.ngrok.conf;

import com.github.alexdlaird.ngrok.installer.NgrokInstaller;
import com.github.alexdlaird.ngrok.installer.NgrokVersion;
import com.github.alexdlaird.ngrok.process.NgrokLog;
import com.github.alexdlaird.ngrok.protocol.Region;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;

public class JavaNgrokConfig {
    private final Path ngrokPath;
    private final Path configPath;
    private final String authToken;
    private final Region region;
    private final boolean keepMonitoring;
    private final int maxLogs;
    private final Function<NgrokLog, Void> logEventCallback;
    private final int startupTimeout;
    private final NgrokVersion ngrokVersion;

    private JavaNgrokConfig(Builder builder) {
        this.ngrokPath = builder.ngrokPath;
        this.configPath = builder.configPath;
        this.authToken = builder.authToken;
        this.region = builder.region;
        this.keepMonitoring = builder.keepMonitoring;
        this.maxLogs = builder.maxLogs;
        this.logEventCallback = builder.logEventCallback;
        this.startupTimeout = builder.startupTimeout;
        this.ngrokVersion = builder.ngrokVersion;
    }

    public Path getNgrokPath() {
        return this.ngrokPath;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public Region getRegion() {
        return this.region;
    }

    public boolean isKeepMonitoring() {
        return this.keepMonitoring;
    }

    public int getMaxLogs() {
        return this.maxLogs;
    }

    public Function<NgrokLog, Void> getLogEventCallback() {
        return this.logEventCallback;
    }

    public int getStartupTime() {
        return this.startupTimeout;
    }

    public NgrokVersion getNgrokVersion() {
        return this.ngrokVersion;
    }

    public static class Builder {
        private Path ngrokPath;
        private Path configPath;
        private String authToken;
        private Region region;
        private boolean keepMonitoring = true;
        private int maxLogs = 100;
        private Function<NgrokLog, Void> logEventCallback;
        private int startupTimeout = 15;
        private NgrokVersion ngrokVersion = NgrokVersion.V3;

        public Builder() {
        }

        public Builder(JavaNgrokConfig javaNgrokConfig) {
            this.ngrokPath = javaNgrokConfig.ngrokPath;
            this.configPath = javaNgrokConfig.configPath;
            this.authToken = javaNgrokConfig.authToken;
            this.region = javaNgrokConfig.region;
            this.keepMonitoring = javaNgrokConfig.keepMonitoring;
            this.maxLogs = javaNgrokConfig.maxLogs;
            this.logEventCallback = javaNgrokConfig.logEventCallback;
            this.startupTimeout = javaNgrokConfig.startupTimeout;
            this.ngrokVersion = javaNgrokConfig.ngrokVersion;
        }

        public Builder withNgrokPath(Path ngrokPath) {
            this.ngrokPath = ngrokPath;
            return this;
        }

        public Builder withConfigPath(Path configPath) {
            this.configPath = configPath;
            return this;
        }

        public Builder withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder withRegion(Region region) {
            this.region = region;
            return this;
        }

        public Builder withoutMonitoring() {
            this.keepMonitoring = false;
            return this;
        }

        public Builder withMaxLogs(int maxLogs) {
            if (maxLogs < 1) {
                throw new IllegalArgumentException("\"maxLogs\" must be greater than 0.");
            }
            this.maxLogs = maxLogs;
            return this;
        }

        public Builder withLogEventCallback(Function<NgrokLog, Void> logEventCallback) {
            this.logEventCallback = logEventCallback;
            return this;
        }

        public Builder withStartupTimeout(int startupTimeout) {
            if (startupTimeout < 1) {
                throw new IllegalArgumentException("\"startupTimeout\" must be greater than 0.");
            }
            this.startupTimeout = startupTimeout;
            return this;
        }

        public Builder withNgrokVersion(NgrokVersion ngrokVersion) {
            this.ngrokVersion = ngrokVersion;
            return this;
        }

        public JavaNgrokConfig build() {
            if (Objects.isNull(this.ngrokPath)) {
                this.ngrokPath = NgrokInstaller.DEFAULT_NGROK_PATH;
            }
            if (Objects.isNull(this.configPath)) {
                this.configPath = NgrokInstaller.DEFAULT_CONFIG_PATH;
            }
            return new JavaNgrokConfig(this);
        }
    }
}

