/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexdlaird.ngrok;

import com.github.alexdlaird.exception.JavaNgrokException;
import com.github.alexdlaird.exception.JavaNgrokHTTPException;
import com.github.alexdlaird.http.DefaultHttpClient;
import com.github.alexdlaird.http.HttpClient;
import com.github.alexdlaird.http.HttpClientException;
import com.github.alexdlaird.http.Response;
import com.github.alexdlaird.ngrok.conf.JavaNgrokConfig;
import com.github.alexdlaird.ngrok.installer.NgrokInstaller;
import com.github.alexdlaird.ngrok.installer.NgrokVersion;
import com.github.alexdlaird.ngrok.process.NgrokProcess;
import com.github.alexdlaird.ngrok.protocol.BindTls;
import com.github.alexdlaird.ngrok.protocol.CreateTunnel;
import com.github.alexdlaird.ngrok.protocol.Proto;
import com.github.alexdlaird.ngrok.protocol.Tunnel;
import com.github.alexdlaird.ngrok.protocol.Tunnels;
import com.github.alexdlaird.ngrok.protocol.Version;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class NgrokClient {
    private static final Logger LOGGER = Logger.getLogger(String.valueOf(NgrokClient.class));
    private static final String VERSION = "1.6.2";
    private final JavaNgrokConfig javaNgrokConfig;
    private final NgrokProcess ngrokProcess;
    private final HttpClient httpClient;
    private final Map<String, Tunnel> currentTunnels = new HashMap<String, Tunnel>();

    private NgrokClient(Builder builder) {
        this.javaNgrokConfig = builder.javaNgrokConfig;
        this.ngrokProcess = builder.ngrokProcess;
        this.httpClient = builder.httpClient;
    }

    public Tunnel connect(CreateTunnel createTunnel) {
        Tunnel tunnel;
        Response<Tunnel> response;
        this.ngrokProcess.start();
        CreateTunnel finalTunnel = this.interpolateTunnelDefinition(createTunnel);
        LOGGER.info(String.format("Opening tunnel named: %s", finalTunnel.getName()));
        try {
            response = this.httpClient.post(String.format("%s/api/tunnels", this.ngrokProcess.getApiUrl()), finalTunnel, Tunnel.class);
        }
        catch (HttpClientException e) {
            throw new JavaNgrokHTTPException(String.format("An error occurred when POSTing to create the tunnel %s.", finalTunnel.getName()), e, e.getUrl(), e.getStatusCode(), e.getBody());
        }
        if (this.javaNgrokConfig.getNgrokVersion() == NgrokVersion.V2 && finalTunnel.getProto() == Proto.HTTP && finalTunnel.getBindTls() == BindTls.BOTH) {
            try {
                Response<Tunnel> getResponse = this.httpClient.get(this.ngrokProcess.getApiUrl() + response.getBody().getUri() + "%20%28http%29", Tunnel.class);
                tunnel = getResponse.getBody();
            }
            catch (HttpClientException e) {
                throw new JavaNgrokHTTPException(String.format("An error occurred when GETing the HTTP tunnel %s.", response.getBody().getName()), e, e.getUrl(), e.getStatusCode(), e.getBody());
            }
        } else {
            tunnel = response.getBody();
        }
        this.currentTunnels.put(tunnel.getPublicUrl(), tunnel);
        return tunnel;
    }

    public Tunnel connect() {
        return this.connect(new CreateTunnel.Builder().build(this.javaNgrokConfig.getNgrokVersion()));
    }

    public void disconnect(String publicUrl) {
        if (!this.ngrokProcess.isRunning()) {
            return;
        }
        if (!this.currentTunnels.containsKey(publicUrl)) {
            this.getTunnels();
            if (!this.currentTunnels.containsKey(publicUrl)) {
                return;
            }
        }
        Tunnel tunnel = this.currentTunnels.get(publicUrl);
        this.ngrokProcess.start();
        LOGGER.info(String.format("Disconnecting tunnel: %s", tunnel.getPublicUrl()));
        try {
            this.httpClient.delete(this.ngrokProcess.getApiUrl() + tunnel.getUri());
        }
        catch (HttpClientException e) {
            throw new JavaNgrokHTTPException(String.format("An error occurred when DELETing the tunnel %s.", publicUrl), e, e.getUrl(), e.getStatusCode(), e.getBody());
        }
    }

    public List<Tunnel> getTunnels() {
        this.ngrokProcess.start();
        try {
            Response<Tunnels> response = this.httpClient.get(String.format("%s/api/tunnels", this.ngrokProcess.getApiUrl()), Tunnels.class);
            this.currentTunnels.clear();
            for (Tunnel tunnel : response.getBody().getTunnels()) {
                this.currentTunnels.put(tunnel.getPublicUrl(), tunnel);
            }
            return new ArrayList<Tunnel>(this.currentTunnels.values());
        }
        catch (HttpClientException e) {
            throw new JavaNgrokHTTPException("An error occurred when GETing the tunnels.", e, e.getUrl(), e.getStatusCode(), e.getBody());
        }
    }

    public void refreshMetrics(Tunnel tunnel) {
        Response<Tunnel> latestTunnel = this.httpClient.get(String.format("%s%s", this.ngrokProcess.getApiUrl(), tunnel.getUri()), Tunnel.class);
        if (Objects.isNull(latestTunnel.getBody().getMetrics()) || latestTunnel.getBody().getMetrics().isEmpty()) {
            throw new JavaNgrokException("The ngrok API did not return \"metrics\" in the response");
        }
        tunnel.setMetrics(latestTunnel.getBody().getMetrics());
    }

    public void kill() {
        this.ngrokProcess.stop();
        this.currentTunnels.clear();
    }

    public void setAuthToken(String authToken) {
        this.ngrokProcess.setAuthToken(authToken);
    }

    public void update() {
        this.ngrokProcess.update();
    }

    public Version getVersion() {
        String ngrokVersion = this.ngrokProcess.getVersion();
        return new Version(ngrokVersion, VERSION);
    }

    public JavaNgrokConfig getJavaNgrokConfig() {
        return this.javaNgrokConfig;
    }

    public NgrokProcess getNgrokProcess() {
        return this.ngrokProcess;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    private CreateTunnel interpolateTunnelDefinition(CreateTunnel createTunnel) {
        String name;
        CreateTunnel.Builder createTunnelBuilder = new CreateTunnel.Builder(createTunnel);
        Map<String, Object> config = Files.exists(this.javaNgrokConfig.getConfigPath(), new LinkOption[0]) ? this.ngrokProcess.getNgrokInstaller().getNgrokConfig(this.javaNgrokConfig.getConfigPath()) : this.ngrokProcess.getNgrokInstaller().getDefaultConfig(this.javaNgrokConfig.getNgrokVersion());
        Map tunnelDefinitions = config.getOrDefault("tunnels", Collections.emptyMap());
        if (Objects.isNull(createTunnel.getName()) && tunnelDefinitions.containsKey("java-ngrok-default")) {
            name = "java-ngrok-default";
            createTunnelBuilder.withName(name);
        } else {
            name = createTunnel.getName();
        }
        if (Objects.nonNull(name) && tunnelDefinitions.containsKey(name)) {
            createTunnelBuilder.withTunnelDefinition((Map)tunnelDefinitions.get(name));
        }
        return createTunnelBuilder.build(this.javaNgrokConfig.getNgrokVersion());
    }

    public static class Builder {
        private JavaNgrokConfig javaNgrokConfig;
        private NgrokInstaller ngrokInstaller;
        private NgrokProcess ngrokProcess;
        private HttpClient httpClient;

        public Builder withJavaNgrokConfig(JavaNgrokConfig javaNgrokConfig) {
            this.javaNgrokConfig = javaNgrokConfig;
            return this;
        }

        public Builder withNgrokInstaller(NgrokInstaller ngrokInstaller) {
            this.ngrokInstaller = ngrokInstaller;
            return this;
        }

        public Builder withNgrokProcess(NgrokProcess ngrokProcess) {
            this.ngrokProcess = ngrokProcess;
            return this;
        }

        public Builder withHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public NgrokClient build() {
            if (Objects.isNull(this.javaNgrokConfig)) {
                this.javaNgrokConfig = new JavaNgrokConfig.Builder().build();
            }
            if (Objects.isNull(this.ngrokInstaller)) {
                this.ngrokInstaller = new NgrokInstaller();
            }
            if (Objects.isNull(this.ngrokProcess)) {
                this.ngrokProcess = new NgrokProcess(this.javaNgrokConfig, this.ngrokInstaller);
            }
            if (Objects.isNull(this.httpClient)) {
                this.httpClient = new DefaultHttpClient.Builder().build();
            }
            return new NgrokClient(this);
        }
    }
}

