/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexdlaird.http;

import com.github.alexdlaird.http.HttpClient;
import com.github.alexdlaird.http.HttpClientException;
import com.github.alexdlaird.http.Parameter;
import com.github.alexdlaird.http.Response;
import com.github.alexdlaird.util.StringUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOGGER = Logger.getLogger(String.valueOf(DefaultHttpClient.class));
    private final Gson gson;
    private final String encoding;
    private final String contentType;

    private DefaultHttpClient(Builder builder) {
        this.encoding = builder.encoding;
        this.contentType = builder.contentType;
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    @Override
    public <B> Response<B> get(String url, List<Parameter> parameters, Map<String, String> additionalHeaders, Class<B> clazz) {
        try {
            return this.execute(this.urlWithParameters(url, parameters), null, "GET", additionalHeaders, clazz);
        }
        catch (IOException e) {
            throw new HttpClientException("HTTP GET error", e);
        }
    }

    @Override
    public <R, B> Response<B> post(String url, R request, List<Parameter> parameters, Map<String, String> additionalHeaders, Class<B> clazz) {
        try {
            return this.execute(this.urlWithParameters(url, parameters), this.convertRequestToString(request), "POST", additionalHeaders, clazz);
        }
        catch (IOException e) {
            throw new HttpClientException("HTTP POST error", e);
        }
    }

    @Override
    public <R, B> Response<B> put(String url, R request, List<Parameter> parameters, Map<String, String> additionalHeaders, Class<B> clazz) {
        try {
            return this.execute(this.urlWithParameters(url, parameters), this.convertRequestToString(request), "PUT", additionalHeaders, clazz);
        }
        catch (IOException e) {
            throw new HttpClientException("HTTP PUT error", e);
        }
    }

    @Override
    public <B> Response<B> delete(String url, List<Parameter> parameters, Map<String, String> additionalHeaders, Class<B> clazz) {
        try {
            return this.execute(this.urlWithParameters(url, parameters), null, "DELETE", additionalHeaders, clazz);
        }
        catch (IOException e) {
            throw new HttpClientException("HTTP DELETE error", e);
        }
    }

    private void appendDefaultsToConnection(HttpURLConnection httpUrlConnection, Map<String, String> additionalHeaders) {
        httpUrlConnection.setRequestProperty("Content-Type", this.contentType);
        if (additionalHeaders != null) {
            for (Map.Entry<String, String> entry : additionalHeaders.entrySet()) {
                httpUrlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected HttpURLConnection createHttpUrlConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    private <T> String convertRequestToString(T request) {
        if (request != null) {
            return this.gson.toJson(request);
        }
        return null;
    }

    private <T> T convertResponseFromString(String response, Class<T> clazz) {
        if (StringUtils.isNotBlank(response)) {
            try {
                return (T)this.gson.fromJson(response, clazz);
            }
            catch (JsonSyntaxException ex) {
                return null;
            }
        }
        return null;
    }

    private String urlWithParameters(String url, List<Parameter> parameters) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url);
        if (parameters != null && parameters.size() > 0) {
            boolean first = true;
            for (Parameter parameter : parameters) {
                if (!first) {
                    stringBuilder.append("&");
                } else {
                    stringBuilder.append("?");
                    first = false;
                }
                stringBuilder.append(URLEncoder.encode(parameter.getName(), this.encoding));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(parameter.getValue(), this.encoding));
            }
        }
        return stringBuilder.toString();
    }

    private <B> Response<B> execute(String url, String body, String method, Map<String, String> additionalHeaders, Class<B> clazz) throws IOException {
        HttpURLConnection httpUrlConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            httpUrlConnection = this.createHttpUrlConnection(url);
            httpUrlConnection.setRequestMethod(method);
            this.appendDefaultsToConnection(httpUrlConnection, additionalHeaders);
            this.modifyConnection(httpUrlConnection);
            if (StringUtils.isNotBlank(body)) {
                httpUrlConnection.setDoOutput(true);
                httpUrlConnection.connect();
                outputStream = httpUrlConnection.getOutputStream();
                outputStream.write(body.getBytes(Charset.forName(this.encoding)));
            } else {
                httpUrlConnection.setRequestProperty("Content-Length", "0");
                httpUrlConnection.connect();
            }
            inputStream = httpUrlConnection.getInputStream();
            String responseBody = StringUtils.streamToString(inputStream, Charset.forName(this.encoding));
            Response<B> response = new Response<B>(httpUrlConnection.getResponseCode(), this.convertResponseFromString(responseBody, clazz), responseBody, httpUrlConnection.getHeaderFields());
            return response;
        }
        catch (Exception ex) {
            Object msg = "An unknown error occurred when performing the operation";
            int statusCode = -1;
            String errorResponse = null;
            if (httpUrlConnection != null) {
                try {
                    statusCode = httpUrlConnection.getResponseCode();
                    errorResponse = StringUtils.streamToString(httpUrlConnection.getErrorStream(), Charset.forName(this.encoding));
                    msg = "An error occurred when performing the operation (" + httpUrlConnection.getResponseCode() + "): " + errorResponse;
                }
                catch (IOException | NullPointerException exception) {
                    // empty catch block
                }
            }
            throw new HttpClientException((String)msg, ex, url, statusCode, errorResponse);
        }
        finally {
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Unable to close connection", ex);
            }
        }
    }

    public static class Builder {
        private String encoding = "UTF-8";
        private String contentType = "application/json";

        public Builder withEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public DefaultHttpClient build() {
            return new DefaultHttpClient(this);
        }
    }
}

