/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.parallel;

import hu.akarnokd.rxjava2.parallel.ParallelOrderedMerge;
import hu.akarnokd.rxjava2.parallel.ParallelSumDouble;
import hu.akarnokd.rxjava2.parallel.ParallelSumInteger;
import hu.akarnokd.rxjava2.parallel.ParallelSumLong;
import io.reactivex.Flowable;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.parallel.ParallelTransformer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Comparator;

public final class ParallelTransformers {
    private ParallelTransformers() {
        throw new IllegalStateException("No instances!");
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source) {
        return ParallelTransformers.orderedMerge(source, Functions.naturalOrder(), false, Flowable.bufferSize());
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source, boolean delayErrors) {
        return ParallelTransformers.orderedMerge(source, Functions.naturalOrder(), delayErrors, Flowable.bufferSize());
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source, boolean delayErrors, int prefetch) {
        return ParallelTransformers.orderedMerge(source, Functions.naturalOrder(), delayErrors, prefetch);
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator) {
        return ParallelTransformers.orderedMerge(source, comparator, false, Flowable.bufferSize());
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator, boolean delayErrors) {
        return ParallelTransformers.orderedMerge(source, comparator, delayErrors, Flowable.bufferSize());
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator, boolean delayErrors, int prefetch) {
        ObjectHelper.requireNonNull(comparator, (String)"comparator is null");
        ObjectHelper.requireNonNull(source, (String)"sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new ParallelOrderedMerge<T>(source, comparator, delayErrors, prefetch));
    }

    public static <T extends Number> ParallelTransformer<T, Integer> sumInteger() {
        return new ParallelSumInteger(null);
    }

    public static <T extends Number> ParallelTransformer<T, Long> sumLong() {
        return new ParallelSumLong(null);
    }

    public static <T extends Number> ParallelTransformer<T, Double> sumDouble() {
        return new ParallelSumDouble(null);
    }
}

