/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class ObservableValve<T>
extends Observable<T>
implements ObservableTransformer<T, T> {
    final Observable<? extends T> source;
    final ObservableSource<Boolean> other;
    final boolean defaultOpen;
    final int bufferSize;

    ObservableValve(Observable<? extends T> source, ObservableSource<Boolean> other, boolean defaultOpen, int bufferSize) {
        this.source = source;
        this.other = other;
        this.defaultOpen = defaultOpen;
        this.bufferSize = bufferSize;
    }

    protected void subscribeActual(Observer<? super T> observer) {
        ValveMainObserver<? super T> parent = new ValveMainObserver<T>(observer, this.bufferSize, this.defaultOpen);
        observer.onSubscribe(parent);
        this.other.subscribe((Observer)parent.other);
        this.source.subscribe(parent);
    }

    public Observable<T> apply(Observable<T> upstream) {
        return new ObservableValve<T>(upstream, this.other, this.defaultOpen, this.bufferSize);
    }

    static final class ValveMainObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -2233734924340471378L;
        final Observer<? super T> downstream;
        final AtomicReference<Disposable> upstream;
        final SimplePlainQueue<T> queue;
        final OtherSubscriber other;
        final AtomicThrowable error;
        volatile boolean done;
        volatile boolean gate;
        volatile boolean cancelled;

        ValveMainObserver(Observer<? super T> downstream, int bufferSize, boolean defaultOpen) {
            this.downstream = downstream;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.gate = defaultOpen;
            this.other = new OtherSubscriber();
            this.error = new AtomicThrowable();
            this.upstream = new AtomicReference();
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, (Disposable)d);
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.error.addThrowable(t)) {
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public boolean isDisposed() {
            return this.cancelled;
        }

        public void dispose() {
            this.cancelled = true;
            DisposableHelper.dispose(this.upstream);
            DisposableHelper.dispose((AtomicReference)this.other);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue<T> q = this.queue;
            Observer<? super T> a = this.downstream;
            AtomicThrowable error = this.error;
            while (true) {
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                if (error.get() != null) {
                    Throwable ex = error.terminate();
                    q.clear();
                    DisposableHelper.dispose(this.upstream);
                    DisposableHelper.dispose((AtomicReference)this.other);
                    a.onError(ex);
                    return;
                }
                if (this.gate) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        DisposableHelper.dispose((AtomicReference)this.other);
                        a.onComplete();
                        return;
                    }
                    if (!empty) {
                        a.onNext(v);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void change(boolean state) {
            this.gate = state;
            if (state) {
                this.drain();
            }
        }

        void innerError(Throwable ex) {
            this.onError(ex);
        }

        void innerComplete() {
            this.innerError(new IllegalStateException("The valve source completed unexpectedly."));
        }

        final class OtherSubscriber
        extends AtomicReference<Disposable>
        implements Observer<Boolean> {
            private static final long serialVersionUID = -3076915855750118155L;

            OtherSubscriber() {
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce((AtomicReference)this, (Disposable)d);
            }

            public void onNext(Boolean t) {
                ValveMainObserver.this.change(t);
            }

            public void onError(Throwable t) {
                ValveMainObserver.this.innerError(t);
            }

            public void onComplete() {
                ValveMainObserver.this.innerComplete();
            }
        }
    }
}

