/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.FlowableAsyncEmitter;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableGenerateAsync<T, S>
extends Flowable<T> {
    final Callable<S> initialState;
    final BiFunction<? super S, ? super FlowableAsyncEmitter<T>, ? extends S> asyncGenerator;
    final Consumer<? super S> stateCleanup;

    FlowableGenerateAsync(Callable<S> initialState, BiFunction<? super S, ? super FlowableAsyncEmitter<T>, ? extends S> asyncGenerator, Consumer<? super S> stateCleanup) {
        this.initialState = initialState;
        this.asyncGenerator = asyncGenerator;
        this.stateCleanup = stateCleanup;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        S state;
        try {
            state = this.initialState.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        GenerateAsyncSubscription<T, S> parent = new GenerateAsyncSubscription<T, S>(s, state, this.asyncGenerator, this.stateCleanup);
        s.onSubscribe(parent);
        parent.moveNext();
    }

    static final class AtomicCancellable
    extends AtomicReference<Cancellable> {
        private static final long serialVersionUID = -8193511349691432602L;
        static final Cancellable CANCELLED = new Cancellable(){

            public void cancel() throws Exception {
            }
        };

        AtomicCancellable() {
        }

        public boolean replaceCancellable(Cancellable c) {
            Cancellable curr;
            do {
                if ((curr = (Cancellable)this.get()) != CANCELLED) continue;
                this.cancel(c);
                return false;
            } while (!this.compareAndSet(curr, c));
            return true;
        }

        public boolean setCancellable(Cancellable c) {
            Cancellable curr;
            do {
                if ((curr = (Cancellable)this.get()) != CANCELLED) continue;
                this.cancel(c);
                return false;
            } while (!this.compareAndSet(curr, c));
            this.cancel(curr);
            return true;
        }

        void cancel() {
            Cancellable c = this.getAndSet(CANCELLED);
            this.cancel(c);
        }

        void cancel(Cancellable c) {
            if (c != null) {
                try {
                    c.cancel();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
            }
        }
    }

    static final class GenerateAsyncSubscription<T, S>
    extends AtomicInteger
    implements Subscription,
    FlowableAsyncEmitter<T> {
        private static final long serialVersionUID = -2460374219999425947L;
        final Subscriber<? super T> downstream;
        final AtomicInteger wip;
        final AtomicLong requested;
        final AtomicCancellable resource;
        final BiFunction<? super S, ? super FlowableAsyncEmitter<T>, ? extends S> asyncGenerator;
        final Consumer<? super S> stateCleanup;
        final AtomicThrowable errors;
        volatile S state;
        T item;
        volatile int itemState;
        static final int ITEM_STATE_NOTHING_YET = 0;
        static final int ITEM_STATE_HAS_VALUE = 1;
        static final int ITEM_STATE_EMPTY = 2;
        static final int ITEM_STATE_DONE = 4;
        static final int ITEM_STATE_HAS_VALUE_DONE = 5;
        static final int ITEM_STATE_EMPTY_DONE = 5;
        volatile boolean done;
        volatile boolean cancelled;
        long emitted;

        GenerateAsyncSubscription(Subscriber<? super T> downstream, S state, BiFunction<? super S, ? super FlowableAsyncEmitter<T>, ? extends S> asyncGenerator, Consumer<? super S> stateCleanup) {
            this.downstream = downstream;
            this.state = state;
            this.asyncGenerator = asyncGenerator;
            this.stateCleanup = stateCleanup;
            this.wip = new AtomicInteger();
            this.requested = new AtomicLong();
            this.resource = new AtomicCancellable();
            this.errors = new AtomicThrowable();
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            this.drain();
        }

        public void cancel() {
            this.cancelled = true;
            this.resource.cancel();
            if (this.getAndIncrement() == 0) {
                this.cleanup();
            }
        }

        void cleanup() {
            try {
                this.stateCleanup.accept(this.state);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        public void onNext(T value) {
            if (value != null) {
                this.item = value;
                this.itemState = 1;
                this.drain();
            } else {
                this.onError(new NullPointerException("value is null"));
            }
        }

        public void onError(Throwable error) {
            if (error == null) {
                error = new NullPointerException("error is null");
            }
            if (this.errors.addThrowable(error)) {
                this.itemState |= 4;
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError((Throwable)error);
            }
        }

        public void onComplete() {
            this.itemState |= 4;
            this.done = true;
            this.drain();
        }

        @Override
        public void onNothing() {
            this.item = null;
            this.itemState = 2;
            this.drain();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean replaceCancellable(Cancellable c) {
            return this.resource.replaceCancellable(c);
        }

        @Override
        public boolean setCancellable(Cancellable c) {
            return this.resource.setCancellable(c);
        }

        void moveNext() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        this.state = this.asyncGenerator.apply(this.state, (Object)this);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.onError(ex);
                        return;
                    }
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super T> downstream = this.downstream;
            long emitted = this.emitted;
            AtomicLong requested = this.requested;
            while (true) {
                if (this.cancelled) {
                    this.cleanup();
                    return;
                }
                boolean d = this.done;
                int s = this.itemState;
                if (d && s == 4) {
                    Throwable ex = this.errors.terminate();
                    if (ex != null) {
                        downstream.onError(ex);
                    } else {
                        downstream.onComplete();
                    }
                    this.resource.cancel();
                    this.cleanup();
                    return;
                }
                if ((s & 0xFFFFFFFB) == 1) {
                    if (emitted != requested.get()) {
                        T v = this.item;
                        this.item = null;
                        downstream.onNext(v);
                        ++emitted;
                        if ((s & 4) != 0) {
                            this.itemState = 4;
                            continue;
                        }
                        this.itemState = 0;
                        this.moveNext();
                        continue;
                    }
                } else if ((s & 0xFFFFFFFB) == 2) {
                    if ((s & 4) != 0) {
                        this.itemState = 4;
                        continue;
                    }
                    this.itemState = 0;
                    this.moveNext();
                    continue;
                }
                this.emitted = emitted;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

