/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import hu.akarnokd.rxjava2.operators.FlowableMapAsync;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.FlowableTransformer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.Pow2;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableFilterAsync<T>
extends Flowable<T>
implements FlowableTransformer<T, T> {
    final Flowable<T> source;
    final Function<? super T, ? extends Publisher<Boolean>> asyncPredicate;
    final int bufferSize;

    FlowableFilterAsync(Flowable<T> source, Function<? super T, ? extends Publisher<Boolean>> asyncPredicate, int bufferSize) {
        this.source = source;
        this.asyncPredicate = asyncPredicate;
        this.bufferSize = bufferSize;
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableFilterAsync<T>(upstream, this.asyncPredicate, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new FilterAsyncSubscriber<T>(s, this.asyncPredicate, this.bufferSize));
    }

    static final class FilterAsyncSubscriber<T>
    extends AtomicReferenceArray<T>
    implements FlowableSubscriber<T>,
    Subscription,
    FlowableMapAsync.AsyncSupport<Boolean> {
        private static final long serialVersionUID = -1557840206706079339L;
        final Subscriber<? super T> downstream;
        final Function<? super T, ? extends Publisher<Boolean>> asyncPredicate;
        final int bufferSize;
        final AtomicThrowable error;
        final AtomicLong requested;
        final AtomicInteger wip;
        final AtomicReference<FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber<Boolean>> current;
        static final FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber INNER_CANCELLED = new FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber(null);
        Subscription upstream;
        long producerIndex;
        long consumerIndex;
        int consumed;
        volatile boolean done;
        volatile boolean cancelled;
        Boolean innerResult;
        long emitted;
        volatile int state;
        static final int STATE_FRESH = 0;
        static final int STATE_RUNNING = 1;
        static final int STATE_RESULT = 2;

        FilterAsyncSubscriber(Subscriber<? super T> downstream, Function<? super T, ? extends Publisher<Boolean>> asyncPredicate, int bufferSize) {
            super(Pow2.roundToPowerOfTwo((int)bufferSize));
            this.downstream = downstream;
            this.asyncPredicate = asyncPredicate;
            this.bufferSize = bufferSize;
            this.error = new AtomicThrowable();
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.current = new AtomicReference();
        }

        public void onNext(T t) {
            long pi = this.producerIndex;
            int m = this.length() - 1;
            int offset = (int)pi & m;
            this.lazySet(offset, t);
            this.producerIndex = pi + 1L;
            this.drain();
        }

        public void onError(Throwable t) {
            this.error.addThrowable(t);
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.cancelInner();
                if (this.wip.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        void cancelInner() {
            FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber<Boolean> a = this.current.get();
            if (a != INNER_CANCELLED && (a = this.current.getAndSet(INNER_CANCELLED)) != null && a != INNER_CANCELLED) {
                a.cancel();
            }
        }

        void clear() {
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                this.lazySet(i, null);
            }
            this.innerResult = null;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request((long)this.bufferSize);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            long e = this.emitted;
            long ci = this.consumerIndex;
            int f = this.consumed;
            int m = this.length() - 1;
            Subscriber<? super T> a = this.downstream;
            while (true) {
                int w;
                boolean empty;
                Object t;
                int offset;
                boolean d;
                long r = this.requested.get();
                while (e != r) {
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    d = this.done;
                    offset = (int)ci & m;
                    t = this.get(offset);
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        Throwable ex = this.error.terminate();
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    int s = this.state;
                    if (s == 0) {
                        Publisher p;
                        try {
                            p = (Publisher)ObjectHelper.requireNonNull((Object)this.asyncPredicate.apply(t), (String)"The asyncPredicate returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal((Throwable)ex);
                            this.error.addThrowable(ex);
                            p = null;
                        }
                        if (p != null) {
                            if (p instanceof Callable) {
                                Boolean u;
                                try {
                                    u = (Boolean)((Callable)p).call();
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal((Throwable)ex);
                                    this.error.addThrowable(ex);
                                    u = null;
                                }
                                if (u != null && u.booleanValue()) {
                                    a.onNext(t);
                                    ++e;
                                }
                            } else {
                                FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber<Boolean> inner = new FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber<Boolean>(this);
                                if (this.current.compareAndSet(null, inner)) {
                                    this.state = 1;
                                    p.subscribe(inner);
                                    break;
                                }
                            }
                        }
                        this.lazySet(offset, null);
                        ++ci;
                        if (++f != limit) continue;
                        f = 0;
                        this.upstream.request((long)limit);
                        continue;
                    }
                    if (s != 2) break;
                    Boolean u = this.innerResult;
                    this.innerResult = null;
                    if (u != null && u.booleanValue()) {
                        ++e;
                        a.onNext(t);
                    }
                    this.lazySet(offset, null);
                    ++ci;
                    if (++f == limit) {
                        f = 0;
                        this.upstream.request((long)limit);
                    }
                    this.state = 0;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.clear();
                        return;
                    }
                    d = this.done;
                    offset = (int)ci & m;
                    t = this.get(offset);
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        Throwable ex = this.error.terminate();
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                if (missed == (w = this.wip.get())) {
                    this.consumed = f;
                    this.consumerIndex = ci;
                    this.emitted = e;
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void clearCurrent() {
            FlowableMapAsync.MapAsyncSubscriber.InnerSubscriber<Boolean> c = this.current.get();
            if (c != INNER_CANCELLED) {
                this.current.compareAndSet(c, null);
            }
        }

        @Override
        public void innerResult(Boolean item) {
            this.innerResult = item;
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }

        @Override
        public void innerError(Throwable ex) {
            this.error.addThrowable(ex);
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }

        @Override
        public void innerComplete() {
            this.state = 2;
            this.clearCurrent();
            this.drain();
        }
    }
}

