/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Completable;
import io.reactivex.CompletableConverter;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalSingle<R>
extends Single<R>
implements CompletableConverter<Single<R>> {
    final Completable source;
    final Callable<? extends SingleSource<? extends R>> onCompleteHandler;
    final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler;

    CompletableFlatMapSignalSingle(Completable source, Callable<? extends SingleSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Single<R> apply(Completable t) {
        return new CompletableFlatMapSignalSingle<R>(t, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(SingleObserver<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<R>(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<R>
    implements CompletableObserver,
    Disposable {
        final SignalConsumer<R> consumer;
        final Callable<? extends SingleSource<? extends R>> onCompleteHandler;
        final Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(SingleObserver<? super R> downstream, Callable<? extends SingleSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            SingleSource next;
            try {
                next = (SingleSource)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            SingleSource next;
            try {
                next = (SingleSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null SingleSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements SingleObserver<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final SingleObserver<? super R> downstream;

            SignalConsumer(SingleObserver<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onSuccess(R t) {
                this.downstream.onSuccess(t);
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

