/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Completable;
import io.reactivex.CompletableConverter;
import io.reactivex.CompletableObserver;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalObservable<R>
extends Observable<R>
implements CompletableConverter<Observable<R>> {
    final Completable source;
    final Callable<? extends ObservableSource<? extends R>> onCompleteHandler;
    final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

    CompletableFlatMapSignalObservable(Completable source, Callable<? extends ObservableSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Observable<R> apply(Completable t) {
        return new CompletableFlatMapSignalObservable<R>(t, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<R>(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<R>
    implements CompletableObserver,
    Disposable {
        final SignalConsumer<R> consumer;
        final Callable<? extends ObservableSource<? extends R>> onCompleteHandler;
        final Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(Observer<? super R> downstream, Callable<? extends ObservableSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            ObservableSource next;
            try {
                next = (ObservableSource)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            ObservableSource next;
            try {
                next = (ObservableSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null ObservableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements Observer<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final Observer<? super R> downstream;

            SignalConsumer(Observer<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onNext(R t) {
                this.downstream.onNext(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

