/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.operators;

import io.reactivex.Completable;
import io.reactivex.CompletableConverter;
import io.reactivex.CompletableObserver;
import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

final class CompletableFlatMapSignalMaybe<R>
extends Maybe<R>
implements CompletableConverter<Maybe<R>> {
    final Completable source;
    final Callable<? extends MaybeSource<? extends R>> onCompleteHandler;
    final Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler;

    CompletableFlatMapSignalMaybe(Completable source, Callable<? extends MaybeSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onCompleteHandler = onCompleteHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Maybe<R> apply(Completable t) {
        return new CompletableFlatMapSignalMaybe<R>(t, this.onCompleteHandler, this.onErrorHandler);
    }

    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<R>(observer, this.onCompleteHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<R>
    implements CompletableObserver,
    Disposable {
        final SignalConsumer<R> consumer;
        final Callable<? extends MaybeSource<? extends R>> onCompleteHandler;
        final Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(MaybeObserver<? super R> downstream, Callable<? extends MaybeSource<? extends R>> onCompleteHandler, Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onCompleteHandler = onCompleteHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onComplete() {
            MaybeSource next;
            try {
                next = (MaybeSource)ObjectHelper.requireNonNull(this.onCompleteHandler.call(), (String)"The onCompleteHandler returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            MaybeSource next;
            try {
                next = (MaybeSource)ObjectHelper.requireNonNull((Object)this.onErrorHandler.apply((Object)e), (String)"The onErrorHandler returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final MaybeObserver<? super R> downstream;

            SignalConsumer(MaybeObserver<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onSuccess(R t) {
                this.downstream.onSuccess(t);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }
        }
    }
}

