/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.debug.validator;

import hu.akarnokd.rxjava2.debug.validator.MultipleOnSubscribeCallsException;
import hu.akarnokd.rxjava2.debug.validator.MultipleTerminationsException;
import hu.akarnokd.rxjava2.debug.validator.NullOnErrorParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnNextParameterException;
import hu.akarnokd.rxjava2.debug.validator.NullOnSubscribeParameterException;
import hu.akarnokd.rxjava2.debug.validator.OnNextAfterTerminationException;
import hu.akarnokd.rxjava2.debug.validator.OnSubscribeNotCalledException;
import hu.akarnokd.rxjava2.debug.validator.ProtocolNonConformanceException;
import hu.akarnokd.rxjava2.functions.PlainConsumer;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableValidator<T>
extends Flowable<T> {
    final Flowable<T> source;
    final PlainConsumer<ProtocolNonConformanceException> onViolation;

    FlowableValidator(Flowable<T> source, PlainConsumer<ProtocolNonConformanceException> onViolation) {
        this.source = source;
        this.onViolation = onViolation;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ValidatorConsumer<T>(s, this.onViolation));
    }

    static final class ValidatorConsumer<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final PlainConsumer<ProtocolNonConformanceException> onViolation;
        Subscription upstream;
        boolean done;

        ValidatorConsumer(Subscriber<? super T> downstream, PlainConsumer<ProtocolNonConformanceException> onViolation) {
            this.downstream = downstream;
            this.onViolation = onViolation;
        }

        public void onSubscribe(Subscription s) {
            Subscription u;
            if (s == null) {
                this.onViolation.accept(new NullOnSubscribeParameterException());
            }
            if ((u = this.upstream) != null) {
                this.onViolation.accept(new MultipleOnSubscribeCallsException());
            }
            this.upstream = s;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            if (t == null) {
                this.onViolation.accept(new NullOnNextParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException());
            }
            if (this.done) {
                this.onViolation.accept(new OnNextAfterTerminationException());
            } else {
                this.downstream.onNext(t);
            }
        }

        public void onError(Throwable e) {
            if (e == null) {
                this.onViolation.accept(new NullOnErrorParameterException());
            }
            if (this.upstream == null) {
                this.onViolation.accept(new OnSubscribeNotCalledException(e));
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException(e));
            } else {
                this.done = true;
                this.downstream.onError(e);
            }
        }

        public void onComplete() {
            if (this.upstream == null) {
                OnSubscribeNotCalledException ex = new OnSubscribeNotCalledException();
                this.onViolation.accept(ex);
            }
            if (this.done) {
                this.onViolation.accept(new MultipleTerminationsException());
            } else {
                this.done = true;
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            this.upstream.cancel();
        }

        public void request(long n) {
            this.upstream.request(n);
        }
    }
}

