/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Solo;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class SoloSubscribeOn<T>
extends Solo<T> {
    final Solo<T> source;
    final Scheduler scheduler;

    SoloSubscribeOn(Solo<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        SubscribeOnSubscriber<? super T> parent = new SubscribeOnSubscriber<T>(s, worker, this.source);
        s.onSubscribe(parent);
        DisposableHelper.replace(parent.task, (Disposable)worker.schedule(parent));
    }

    static final class SubscribeOnSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    Runnable,
    Subscription {
        private static final long serialVersionUID = 2047863608816341143L;
        final Subscriber<? super T> downstream;
        final Scheduler.Worker worker;
        final AtomicReference<Disposable> task;
        final Publisher<T> source;
        final AtomicBoolean requested;

        SubscribeOnSubscriber(Subscriber<? super T> downstream, Scheduler.Worker worker, Publisher<T> source) {
            this.downstream = downstream;
            this.worker = worker;
            this.source = source;
            this.task = new AtomicReference();
            this.requested = new AtomicBoolean();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s) && this.requested.getAndSet(false)) {
                this.scheduleRequest();
            }
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.worker.dispose();
        }

        public void onComplete() {
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void run() {
            this.source.subscribe((Subscriber)this);
        }

        void scheduleRequest() {
            this.worker.schedule(new Runnable(){

                @Override
                public void run() {
                    ((Subscription)SubscribeOnSubscriber.this.get()).request(Long.MAX_VALUE);
                }
            });
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                Subscription s = (Subscription)this.get();
                if (s != null) {
                    this.scheduleRequest();
                } else {
                    this.requested.set(true);
                    s = (Subscription)this.get();
                    if (s != null && this.requested.getAndSet(false)) {
                        this.scheduleRequest();
                    }
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
            DisposableHelper.dispose(this.task);
            this.worker.dispose();
        }
    }
}

