/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsFlatMapSignal<T, R>
extends Perhaps<R> {
    final Perhaps<T> source;
    final Function<? super T, ? extends Perhaps<? extends R>> onSuccessMapper;
    final Function<? super Throwable, ? extends Perhaps<? extends R>> onErrorMapper;
    final Callable<? extends Perhaps<? extends R>> onCompleteMapper;

    PerhapsFlatMapSignal(Perhaps<T> source, Function<? super T, ? extends Perhaps<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends Perhaps<? extends R>> onErrorMapper, Callable<? extends Perhaps<? extends R>> onCompleteMapper) {
        this.source = source;
        this.onSuccessMapper = onSuccessMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteMapper = onCompleteMapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(s, this.onSuccessMapper, this.onErrorMapper, this.onCompleteMapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends DeferredScalarSubscription<R>
    implements Subscriber<T> {
        private static final long serialVersionUID = 1417117475410404413L;
        final Function<? super T, ? extends Perhaps<? extends R>> onSuccessMapper;
        final Function<? super Throwable, ? extends Perhaps<? extends R>> onErrorMapper;
        final Callable<? extends Perhaps<? extends R>> onCompleteMapper;
        final InnerSubscriber inner;
        Subscription upstream;
        boolean hasValue;

        FlatMapSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Perhaps<? extends R>> onSuccessMapper, Function<? super Throwable, ? extends Perhaps<? extends R>> onErrorMapper, Callable<? extends Perhaps<? extends R>> onCompleteMapper) {
            super(downstream);
            this.onSuccessMapper = onSuccessMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteMapper = onCompleteMapper;
            this.inner = new InnerSubscriber();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Perhaps ph;
            this.hasValue = true;
            try {
                ph = (Perhaps)ObjectHelper.requireNonNull((Object)this.onSuccessMapper.apply(t), (String)"The onSuccessMapper returned a null Perhaps");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            ph.subscribe(this.inner);
        }

        public void onError(Throwable t) {
            Perhaps ph;
            try {
                ph = (Perhaps)ObjectHelper.requireNonNull((Object)this.onErrorMapper.apply((Object)t), (String)"The onErrorMapper returned a null Perhaps");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.downstream.onError(ex);
                return;
            }
            ph.subscribe(this.inner);
        }

        public void onComplete() {
            if (!this.hasValue) {
                Perhaps ph;
                try {
                    ph = (Perhaps)ObjectHelper.requireNonNull(this.onCompleteMapper.call(), (String)"The onCompleteMapper returned a null Perhaps");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError(ex);
                    return;
                }
                ph.subscribe(this.inner);
            }
        }

        void innerNext(R t) {
            this.value = t;
        }

        void innerError(Throwable ex) {
            this.downstream.onError(ex);
        }

        void innerComplete() {
            Object v = this.value;
            if (v != null) {
                this.complete(v);
            } else {
                this.downstream.onComplete();
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.inner);
        }

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = -7349825169192389387L;

            InnerSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                FlatMapSubscriber.this.innerNext(t);
            }

            public void onError(Throwable t) {
                FlatMapSubscriber.this.innerError(t);
            }

            public void onComplete() {
                FlatMapSubscriber.this.innerComplete();
            }
        }
    }
}

