/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoRepeat
extends Nono {
    final Nono source;
    final long times;

    NonoRepeat(Nono source, long times) {
        this.source = source;
        this.times = times;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.source.subscribe(new RepeatSubscriber(s, this.times, this.source));
    }

    static final class RepeatSubscriber
    extends RedoSubscriber {
        private static final long serialVersionUID = 3432411068139897716L;

        RepeatSubscriber(Subscriber<? super Void> downstream, long times, Nono source) {
            super(downstream, times, source);
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.active = false;
            this.subscribeNext(null);
        }
    }

    static abstract class RedoSubscriber
    extends BasicNonoIntQueueSubscription
    implements Subscriber<Void> {
        private static final long serialVersionUID = -3208438978515192633L;
        protected final Subscriber<? super Void> downstream;
        final Nono source;
        long times;
        final AtomicReference<Subscription> upstream;
        protected volatile boolean active;
        boolean once;

        RedoSubscriber(Subscriber<? super Void> downstream, long times, Nono source) {
            this.downstream = downstream;
            this.times = times;
            this.source = source;
            this.upstream = new AtomicReference();
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace(this.upstream, (Subscription)s);
            if (!this.once) {
                this.once = true;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Void t) {
        }

        protected final void subscribeNext(Throwable ex) {
            long p = this.times;
            if (p == 1L) {
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            } else {
                if (p != Long.MAX_VALUE) {
                    this.times = p - 1L;
                }
                if (this.getAndIncrement() == 0) {
                    do {
                        if (SubscriptionHelper.CANCELLED == this.upstream.get()) {
                            return;
                        }
                        if (this.active) continue;
                        this.active = true;
                        this.source.subscribe(this);
                    } while (this.decrementAndGet() != 0);
                }
            }
        }
    }
}

