/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoOnErrorResume
extends Nono {
    final Nono source;
    final Function<? super Throwable, ? extends Nono> errorHandler;

    NonoOnErrorResume(Nono source, Function<? super Throwable, ? extends Nono> errorHandler) {
        this.source = source;
        this.errorHandler = errorHandler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.source.subscribe(new OnErrorResumeSubscriber(s, this.errorHandler));
    }

    static final class OnErrorResumeSubscriber
    extends BasicRefQueueSubscription<Void, Subscription>
    implements Subscriber<Void> {
        private static final long serialVersionUID = 5344018235737739066L;
        final Subscriber<? super Void> downstream;
        final Function<? super Throwable, ? extends Nono> errorHandler;
        boolean once;

        OnErrorResumeSubscriber(Subscriber<? super Void> downstream, Function<? super Throwable, ? extends Nono> errorHandler) {
            this.downstream = downstream;
            this.errorHandler = errorHandler;
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
            if (!this.once) {
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            if (!this.once) {
                Nono np;
                this.once = true;
                try {
                    np = (Nono)this.errorHandler.apply((Object)t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    this.downstream.onError((Throwable)new CompositeException(new Throwable[]{t, ex}));
                    return;
                }
                np.subscribe(this);
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

