/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicNonoIntQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoMerge
extends Nono {
    final Publisher<? extends Nono> sources;
    final boolean delayErrors;
    final int maxConcurrency;

    NonoMerge(Publisher<? extends Nono> sources, boolean delayErrors, int maxConcurrency) {
        this.sources = sources;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        this.sources.subscribe((Subscriber)new MergeSubscriber(s, this.delayErrors, this.maxConcurrency));
    }

    static final class MergeSubscriber
    extends BasicNonoIntQueueSubscription
    implements Subscriber<Nono> {
        private static final long serialVersionUID = 1247749138466245004L;
        final Subscriber<? super Void> downstream;
        final CompositeDisposable set;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicThrowable errors;
        Subscription upstream;

        MergeSubscriber(Subscriber<? super Void> downstream, boolean delayErrors, int maxConcurrency) {
            this.downstream = downstream;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.lazySet(1);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                int m = this.maxConcurrency;
                if (m == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request((long)m);
                }
            }
        }

        public void onNext(Nono t) {
            this.getAndIncrement();
            MergeInnerSubscriber inner = new MergeInnerSubscriber();
            this.set.add((Disposable)inner);
            t.subscribe(inner);
        }

        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                    Throwable ex = this.errors.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(ex);
                    }
                } else {
                    this.onComplete();
                }
            } else {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        void innerComplete(Disposable inner) {
            this.set.delete(inner);
            this.complete();
        }

        void complete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex != null) {
                    this.downstream.onError(ex);
                } else {
                    this.downstream.onComplete();
                }
            } else {
                this.upstream.request(1L);
            }
        }

        void innerError(Disposable inner, Throwable error) {
            this.set.delete(inner);
            if (this.errors.addThrowable(error)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                    Throwable ex = this.errors.terminate();
                    if (ex != ExceptionHelper.TERMINATED) {
                        this.downstream.onError(ex);
                    }
                } else {
                    this.complete();
                }
            } else {
                RxJavaPlugins.onError((Throwable)error);
            }
        }

        public void cancel() {
            this.upstream.cancel();
            this.set.dispose();
        }

        final class MergeInnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<Void>,
        Disposable {
            private static final long serialVersionUID = -2042478764098922486L;

            MergeInnerSubscriber() {
            }

            public void dispose() {
                SubscriptionHelper.cancel((AtomicReference)this);
            }

            public boolean isDisposed() {
                return SubscriptionHelper.CANCELLED == this.get();
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s);
            }

            public void onNext(Void t) {
            }

            public void onError(Throwable t) {
                MergeSubscriber.this.innerError(this, t);
            }

            public void onComplete() {
                MergeSubscriber.this.innerComplete(this);
            }
        }
    }
}

