/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.BasicRefQueueSubscription;
import hu.akarnokd.rxjava2.basetypes.Nono;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoConcatArray
extends Nono {
    final Nono[] sources;
    final boolean delayError;

    NonoConcatArray(Nono[] sources, boolean delayError) {
        this.sources = sources;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        ConcatSubscriber parent = new ConcatSubscriber(s, this.sources, this.delayError);
        s.onSubscribe((Subscription)parent);
        parent.drain();
    }

    static final class ConcatSubscriber
    extends BasicRefQueueSubscription<Void, Subscription>
    implements Subscriber<Void> {
        private static final long serialVersionUID = -4926738846855955051L;
        final Subscriber<? super Void> downstream;
        final AtomicThrowable errors;
        final Nono[] sources;
        final AtomicInteger wip;
        int index;
        volatile boolean active;

        ConcatSubscriber(Subscriber<? super Void> downstream, Nono[] sources, boolean delayError) {
            this.downstream = downstream;
            this.sources = sources;
            this.errors = delayError ? new AtomicThrowable() : null;
            this.wip = new AtomicInteger();
        }

        public void cancel() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.replace((AtomicReference)this, (Subscription)s);
        }

        public void onNext(Void t) {
        }

        public void onError(Throwable t) {
            AtomicThrowable err = this.errors;
            if (err != null) {
                err.addThrowable(t);
                this.active = false;
                this.drain();
            } else {
                this.downstream.onError(t);
            }
        }

        public void onComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            do {
                if (SubscriptionHelper.CANCELLED == this.get()) {
                    return;
                }
                if (this.active) continue;
                int idx = this.index;
                if (idx == this.sources.length) {
                    Throwable ex;
                    Throwable throwable = ex = this.errors != null ? this.errors.terminate() : null;
                    if (ex != null) {
                        this.downstream.onError(ex);
                    } else {
                        this.downstream.onComplete();
                    }
                    return;
                }
                Nono np = this.sources[idx];
                this.index = idx + 1;
                if (np == null) {
                    NullPointerException npe = new NullPointerException("One of the sources is null");
                    if (this.errors != null) {
                        this.errors.addThrowable((Throwable)npe);
                        this.downstream.onError(this.errors.terminate());
                    } else {
                        this.downstream.onError((Throwable)npe);
                    }
                    return;
                }
                this.active = true;
                np.subscribe(this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

