/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FuturePerhapsSubscriber<T>
extends CountDownLatch
implements Subscriber<T>,
Future<T>,
Subscription {
    T value;
    Throwable error;
    final AtomicReference<Subscription> upstream = new AtomicReference();

    FuturePerhapsSubscriber() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Subscription a;
        do {
            if ((a = this.upstream.get()) != this && a != SubscriptionHelper.CANCELLED) continue;
            return false;
        } while (!this.upstream.compareAndSet(a, (Subscription)SubscriptionHelper.CANCELLED));
        if (a != null) {
            a.cancel();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return SubscriptionHelper.CANCELLED == this.upstream.get();
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L && !this.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        this.value = t;
    }

    public void onError(Throwable t) {
        Subscription a;
        do {
            if ((a = this.upstream.get()) == this || a == SubscriptionHelper.CANCELLED) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
        } while (!this.upstream.compareAndSet(a, this));
        this.countDown();
    }

    public void onComplete() {
        Subscription a;
        do {
            if ((a = this.upstream.get()) != this && a != SubscriptionHelper.CANCELLED) continue;
            return;
        } while (!this.upstream.compareAndSet(a, this));
        this.countDown();
    }

    public void cancel() {
    }

    public void request(long n) {
    }
}

